/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model.solver.realtime;

import java.util.Map;
import java.util.Set;
import org.kie.server.services.taskassigning.core.model.Group;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.core.model.User;
import org.kie.server.services.taskassigning.core.model.solver.realtime.ProblemFactChangeUtil;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;

public class UserPropertyChangeProblemFactChange
implements ProblemFactChange<TaskAssigningSolution> {
    private User user;
    private boolean enabled;
    private Map<String, Object> attributes;
    private Map<String, Set<Object>> labelValues;
    private Set<Group> groups;

    public UserPropertyChangeProblemFactChange(User user, boolean enabled, Map<String, Object> attributes, Map<String, Set<Object>> labelValues, Set<Group> groups) {
        this.user = user;
        this.enabled = enabled;
        this.attributes = attributes;
        this.labelValues = labelValues;
        this.groups = groups;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, Set<Object>> getLabelValues() {
        return this.labelValues;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void doChange(ScoreDirector<TaskAssigningSolution> scoreDirector) {
        User workingUser = (User)scoreDirector.lookUpWorkingObjectOrReturnNull((Object)this.user);
        if (workingUser == null) {
            return;
        }
        scoreDirector.beforeProblemPropertyChanged((Object)workingUser);
        workingUser.setEnabled(this.enabled);
        workingUser.setAllLabelValues(this.labelValues);
        workingUser.setAttributes(this.attributes);
        workingUser.setGroups(this.groups);
        scoreDirector.afterProblemPropertyChanged((Object)workingUser);
        ProblemFactChangeUtil.releaseNonPinnedTasks(workingUser, scoreDirector);
        scoreDirector.triggerVariableListeners();
    }
}

