/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment.impl.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.services.task.assignment.LoadCalculator;
import org.jbpm.services.task.assignment.UserTaskLoad;
import org.jbpm.services.task.commands.TaskContext;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.assignment.Assignment;
import org.kie.internal.task.api.assignment.AssignmentStrategy;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalanceAssignmentStrategy
implements AssignmentStrategy {
    private static final Logger logger = LoggerFactory.getLogger(LoadBalanceAssignmentStrategy.class);
    private static final String IDENTIFIER = "LoadBalance";
    private LoadCalculator calculator;
    private Function<OrganizationalEntity, User> entityToUser = oe -> (User)oe;

    public LoadBalanceAssignmentStrategy() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String calculatorClass = System.getProperty("org.jbpm.task.assignment.loadbalance.calculator", "org.jbpm.services.task.assignment.impl.TaskCountLoadCalculator");
        this.calculator = (LoadCalculator)Class.forName(calculatorClass).newInstance();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public Assignment apply(Task task, org.kie.api.task.TaskContext taskContext, String excludedUser) {
        UserInfo userInfo = (UserInfo)((TaskContext)taskContext).get("org.kie.api.task.UserInfo");
        List<OrganizationalEntity> excluded = LoadBalanceAssignmentStrategy.getExcludedEntities(task, userInfo);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners().stream().filter(oe -> oe instanceof User && !excluded.contains(oe) && !oe.getId().equals(excludedUser)).collect(Collectors.toList());
        task.getPeopleAssignments().getPotentialOwners().stream().filter(oe -> oe instanceof Group).forEach(oe -> {
            Iterator groupUsers = userInfo.getMembersForGroup((Group)oe);
            if (groupUsers != null) {
                groupUsers.forEachRemaining(user -> {
                    if (!(user == null || excluded.contains(user) || potentialOwners.contains(user) || user.getId().equals(excludedUser))) {
                        potentialOwners.add(user);
                    }
                });
            }
        });
        logger.debug("Asking the load calculator [{}] for task loads for the users {}", (Object)this.calculator.getIdentifier(), potentialOwners);
        List<User> users = potentialOwners.stream().map(this.entityToUser).collect(Collectors.toList());
        Collection<UserTaskLoad> loads = this.calculator.getUserTaskLoads(users, taskContext);
        UserTaskLoad lightestLoad = loads.stream().min(UserTaskLoad::compareTo).orElse(null);
        return lightestLoad != null ? new Assignment(lightestLoad.getUser().getId()) : null;
    }

    private static List<OrganizationalEntity> getExcludedEntities(Task task, UserInfo userInfo) {
        List excluded = ((InternalPeopleAssignments)task.getPeopleAssignments()).getExcludedOwners();
        ArrayList excludedUsers = new ArrayList();
        for (OrganizationalEntity entity : excluded) {
            if (!(entity instanceof Group)) continue;
            userInfo.getMembersForGroup((Group)entity).forEachRemaining(excludedUsers::add);
        }
        excluded.addAll(excludedUsers);
        return excluded;
    }
}

