/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.xml.jaxb.util.JaxbMapAdapter;
import org.jbpm.services.task.assignment.AssignmentService;
import org.jbpm.services.task.assignment.AssignmentServiceProvider;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.impl.model.xml.JaxbTask;
import org.jbpm.services.task.impl.util.DeadlineSchedulerHelper;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.Operation;

@XmlRootElement(name="add-task-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AddTaskCommand
extends UserGroupCallbackTaskCommand<Long> {
    private static final long serialVersionUID = 743368767949233891L;
    @XmlElement
    private JaxbTask jaxbTask;
    @XmlTransient
    private Task task;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="parameter")
    private Map<String, Object> params;
    @XmlTransient
    private ContentData data;

    public AddTaskCommand() {
    }

    public AddTaskCommand(Task task, Map<String, Object> params) {
        this.setTask(task);
        this.params = params;
    }

    public AddTaskCommand(Task task, ContentData data) {
        this.setTask(task);
        this.data = data;
    }

    @Override
    public Long execute(Context cntxt) {
        Long taskId = null;
        TaskContext context = (TaskContext)cntxt;
        if (this.task == null) {
            this.task = this.jaxbTask;
        }
        Task taskImpl = null;
        taskImpl = this.task instanceof JaxbTask ? ((JaxbTask)this.task).getTask() : this.task;
        this.initializeTask(taskImpl);
        context.getTaskRuleService().executeRules(taskImpl, this.userId, this.data != null ? this.data : this.params, "addTask");
        ((InternalTaskData)taskImpl.getTaskData()).setTaskInputVariables(this.params);
        AssignmentService assignmentService = AssignmentServiceProvider.get();
        if (assignmentService.isEnabled()) {
            assignmentService.assignTask(taskImpl, (org.kie.api.task.TaskContext)context);
        }
        this.doCallbackOperationForPeopleAssignments((InternalPeopleAssignments)taskImpl.getPeopleAssignments(), context);
        this.doCallbackOperationForTaskData((InternalTaskData)taskImpl.getTaskData(), context);
        this.doCallbackOperationForTaskDeadlines(((InternalTask)taskImpl).getDeadlines(), context);
        taskId = this.data != null ? Long.valueOf(context.getTaskInstanceService().addTask(taskImpl, this.data)) : Long.valueOf(context.getTaskInstanceService().addTask(taskImpl, this.params));
        if (!Status.Created.equals((Object)taskImpl.getTaskData().getStatus())) {
            context.getTaskInstanceService().fireEvent(Operation.Activate, this.task.getId().longValue());
        }
        DeadlineSchedulerHelper.scheduleDeadlinesForTask((InternalTask)taskImpl, context, TaskDeadlinesService.DeadlineType.values());
        return taskId;
    }

    public JaxbTask getJaxbTask() {
        return this.jaxbTask;
    }

    public void setJaxbTask(JaxbTask jaxbTask) {
        this.jaxbTask = jaxbTask;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
        this.jaxbTask = task instanceof JaxbTask ? (JaxbTask)task : new JaxbTask(task);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public ContentData getData() {
        return this.data;
    }

    public void setData(ContentData data) {
        this.data = data;
    }

    private void initializeTask(Task task) {
        Status assignedStatus = null;
        if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getPotentialOwners() != null && task.getPeopleAssignments().getPotentialOwners().size() == 1) {
            OrganizationalEntity potentialOwner = (OrganizationalEntity)task.getPeopleAssignments().getPotentialOwners().get(0);
            if (potentialOwner instanceof User) {
                ((InternalTaskData)task.getTaskData()).setActualOwner((User)potentialOwner);
                assignedStatus = Status.Reserved;
            }
            if (potentialOwner instanceof Group) {
                assignedStatus = Status.Ready;
            }
        } else if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getPotentialOwners() != null && task.getPeopleAssignments().getPotentialOwners().size() > 1) {
            assignedStatus = Status.Ready;
        }
        if (assignedStatus != null) {
            ((InternalTaskData)task.getTaskData()).setStatus(assignedStatus);
        }
    }
}

