/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.scenariosimulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.kie.server.remote.rest.scenariosimulation.ScenarioSimulationResource;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.scenariosimulation.ScenarioSimulationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioSimulationRestApplicationComponentsService
implements KieServerApplicationComponentsService {
    private static final Logger logger = LoggerFactory.getLogger(ScenarioSimulationRestApplicationComponentsService.class);
    private static final String OWNER_EXTENSION = "Scenario Simulation";

    public Collection<Object> getAppComponents(String extension, SupportedTransports type, Object ... services) {
        if (!Objects.equals(OWNER_EXTENSION, extension)) {
            return Collections.emptyList();
        }
        Optional<ScenarioSimulationService> simulationService = Arrays.stream(services).filter(elem -> ScenarioSimulationService.class.isAssignableFrom(elem.getClass())).map(ScenarioSimulationService.class::cast).findFirst();
        ArrayList<Object> components = new ArrayList<Object>(1);
        if (SupportedTransports.REST.equals((Object)type)) {
            if (simulationService.isPresent()) {
                components.add(new ScenarioSimulationResource(simulationService.get()));
            } else {
                logger.error("Impossible to load Test Scenario extension because of missing ScenarioSimulationService. This should never happen if ScenarioSimulationKieServerExtension is properly deployed and activated");
            }
        }
        return components;
    }
}

