/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.sql.Connection;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.CreateTable;
import org.dashbuilder.dataprovider.sql.model.Delete;
import org.dashbuilder.dataprovider.sql.model.DropTable;
import org.dashbuilder.dataprovider.sql.model.DynamicDateColumn;
import org.dashbuilder.dataprovider.sql.model.FixedDateColumn;
import org.dashbuilder.dataprovider.sql.model.FunctionColumn;
import org.dashbuilder.dataprovider.sql.model.Insert;
import org.dashbuilder.dataprovider.sql.model.Select;
import org.dashbuilder.dataprovider.sql.model.SimpleColumn;
import org.dashbuilder.dataprovider.sql.model.Table;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;

public class SQLFactory {
    public static Select select(Connection connection) {
        Dialect dialect = JDBCUtils.dialect(connection);
        return new Select(connection, dialect);
    }

    public static Insert insert(Connection connection) {
        Dialect dialect = JDBCUtils.dialect(connection);
        return new Insert(connection, dialect);
    }

    public static Delete delete(Connection connection) {
        Dialect dialect = JDBCUtils.dialect(connection);
        return new Delete(connection, dialect);
    }

    public static CreateTable createTable(Connection connection) {
        Dialect dialect = JDBCUtils.dialect(connection);
        return new CreateTable(connection, dialect);
    }

    public static DropTable dropTable(Connection connection) {
        Dialect dialect = JDBCUtils.dialect(connection);
        return new DropTable(connection, dialect);
    }

    public static Table table(String name) {
        return new Table(name);
    }

    public static Table table(String schema, String name) {
        return new Table(schema, name);
    }

    public static Column column(String name) {
        return new SimpleColumn(name);
    }

    public static Column column(String name, ColumnType type, int size) {
        return new SimpleColumn(name, type, size);
    }

    public static Column column(String name, GroupStrategy strategy, DateIntervalType type) {
        if (GroupStrategy.FIXED.equals((Object)strategy)) {
            return new FixedDateColumn(name, type);
        }
        return new DynamicDateColumn(name, type);
    }

    public static Column concat(Column ... columns) {
        return new FunctionColumn("concat", columns);
    }
}

