/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.ManagedAuditEventBuilderImpl;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.SimpleRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.audit.TaskAuditLoggerFactory;
import org.jbpm.services.task.audit.jms.AsyncTaskLifeCycleEventProducer;
import org.jbpm.services.task.wih.LocalHTWorkItemHandler;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.runtime.Closeable;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.ObjectModelResolver;
import org.kie.internal.runtime.conf.ObjectModelResolverProvider;
import org.kie.internal.runtime.manager.InternalRuntimeEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegisterableItemsFactory
extends SimpleRegisterableItemsFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRegisterableItemsFactory.class);
    private AuditEventBuilder auditBuilder = new ManagedAuditEventBuilderImpl();
    private AbstractAuditLogger jmsLogger = null;
    private AsyncTaskLifeCycleEventProducer jmsTaskLogger = null;

    @Override
    public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
        HashMap<String, WorkItemHandler> defaultHandlers = new HashMap<String, WorkItemHandler>();
        WorkItemHandler handler = this.getHTWorkItemHandler(runtime);
        if (handler != null) {
            defaultHandlers.put("Human Task", handler);
        }
        defaultHandlers.putAll(super.getWorkItemHandlers(runtime));
        defaultHandlers.putAll(this.getWorkItemHandlersFromDescriptor(runtime));
        return defaultHandlers;
    }

    @Override
    public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
        KieSession ksession = ((InternalRuntimeEngine)runtime).internalGetKieSession();
        ArrayList<ProcessEventListener> defaultListeners = new ArrayList<ProcessEventListener>();
        DeploymentDescriptor descriptor = this.getRuntimeManager().getDeploymentDescriptor();
        if (descriptor == null) {
            AbstractAuditLogger logger = AuditLoggerFactory.newJPAInstance((Environment)ksession.getEnvironment());
            logger.setBuilder(this.getAuditBuilder(runtime));
            defaultListeners.add((ProcessEventListener)logger);
        } else if (descriptor.getAuditMode() == AuditMode.JPA) {
            AbstractAuditLogger logger = null;
            if (descriptor.getPersistenceUnit().equals(descriptor.getAuditPersistenceUnit())) {
                logger = AuditLoggerFactory.newJPAInstance((Environment)ksession.getEnvironment());
            } else {
                Environment env = EnvironmentFactory.newEnvironment();
                env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)EntityManagerFactoryManager.get().getOrCreate(descriptor.getAuditPersistenceUnit()));
                logger = AuditLoggerFactory.newJPAInstance((Environment)env);
            }
            logger.setBuilder(this.getAuditBuilder(runtime));
            defaultListeners.add((ProcessEventListener)logger);
        } else if (descriptor.getAuditMode() == AuditMode.JMS) {
            try {
                if (this.jmsLogger == null) {
                    Properties properties = this.loadJMSProperties();
                    logger.debug("Creating AsyncAuditLogProducer {}", (Object)properties);
                    this.jmsLogger = AuditLoggerFactory.newJMSInstance((Map)properties);
                    this.jmsLogger.setBuilder(this.getAuditBuilder(runtime));
                }
                defaultListeners.add((ProcessEventListener)this.jmsLogger);
            }
            catch (IOException e) {
                logger.error("Unable to load jms audit properties from {}", (Object)"/jbpm.audit.jms.properties", (Object)e);
            }
        }
        defaultListeners.addAll(super.getProcessEventListeners(runtime));
        defaultListeners.addAll(this.getEventListenerFromDescriptor(runtime, ProcessEventListener.class));
        return defaultListeners;
    }

    @Override
    public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
        ArrayList<AgendaEventListener> defaultListeners = new ArrayList<AgendaEventListener>();
        defaultListeners.addAll(super.getAgendaEventListeners(runtime));
        defaultListeners.addAll(this.getEventListenerFromDescriptor(runtime, AgendaEventListener.class));
        return defaultListeners;
    }

    @Override
    public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners(RuntimeEngine runtime) {
        ArrayList<RuleRuntimeEventListener> defaultListeners = new ArrayList<RuleRuntimeEventListener>();
        defaultListeners.addAll(super.getRuleRuntimeEventListeners(runtime));
        defaultListeners.addAll(this.getEventListenerFromDescriptor(runtime, RuleRuntimeEventListener.class));
        return defaultListeners;
    }

    @Override
    public List<TaskLifeCycleEventListener> getTaskListeners() {
        ArrayList<TaskLifeCycleEventListener> defaultListeners = new ArrayList<TaskLifeCycleEventListener>();
        DeploymentDescriptor descriptor = this.getRuntimeManager().getDeploymentDescriptor();
        if (descriptor == null) {
            defaultListeners.add((TaskLifeCycleEventListener)new JPATaskLifeCycleEventListener(true));
        } else if (descriptor.getAuditMode() == AuditMode.JPA) {
            if (descriptor.getPersistenceUnit().equals(descriptor.getAuditPersistenceUnit())) {
                defaultListeners.add((TaskLifeCycleEventListener)TaskAuditLoggerFactory.newJPAInstance());
            } else {
                defaultListeners.add((TaskLifeCycleEventListener)TaskAuditLoggerFactory.newJPAInstance((EntityManagerFactory)EntityManagerFactoryManager.get().getOrCreate(descriptor.getAuditPersistenceUnit())));
            }
        } else if (descriptor.getAuditMode() == AuditMode.JMS) {
            if (this.jmsTaskLogger == null) {
                try {
                    Properties properties = this.loadJMSProperties();
                    this.jmsTaskLogger = TaskAuditLoggerFactory.newJMSInstance((Map)properties);
                }
                catch (IOException e) {
                    logger.error("Unable to load jms audit properties from {}", (Object)"/jbpm.audit.jms.properties", (Object)e);
                }
            }
            defaultListeners.add((TaskLifeCycleEventListener)this.jmsTaskLogger);
        }
        defaultListeners.addAll(super.getTaskListeners());
        defaultListeners.addAll(this.getTaskListenersFromDescriptor());
        return defaultListeners;
    }

    @Override
    public Map<String, Object> getGlobals(RuntimeEngine runtime) {
        HashMap<String, Object> defaultGlobals = new HashMap<String, Object>();
        defaultGlobals.putAll(super.getGlobals(runtime));
        defaultGlobals.putAll(this.getGlobalsFromDescriptor(runtime));
        return defaultGlobals;
    }

    protected WorkItemHandler getHTWorkItemHandler(RuntimeEngine runtime) {
        LocalHTWorkItemHandler humanTaskHandler = new LocalHTWorkItemHandler();
        humanTaskHandler.setRuntimeManager(((RuntimeEngineImpl)runtime).getManager());
        return humanTaskHandler;
    }

    public AuditEventBuilder getAuditBuilder() {
        return this.auditBuilder;
    }

    public AuditEventBuilder getAuditBuilder(RuntimeEngine engine) {
        if (this.auditBuilder != null && this.auditBuilder instanceof ManagedAuditEventBuilderImpl) {
            String identifier = ((RuntimeEngineImpl)engine).getManager().getIdentifier();
            ((ManagedAuditEventBuilderImpl)this.auditBuilder).setOwnerId(identifier);
        }
        return this.auditBuilder;
    }

    public void setAuditBuilder(AuditEventBuilder auditBuilder) {
        this.auditBuilder = auditBuilder;
    }

    protected Object getInstanceFromModel(ObjectModel model, ClassLoader classloader, Map<String, Object> contaxtParams) {
        ObjectModelResolver resolver = ObjectModelResolverProvider.get((String)model.getResolver());
        if (resolver == null) {
            throw new IllegalStateException("Unable to find ObjectModelResolver for " + model.getResolver());
        }
        return resolver.getInstance(model, classloader, contaxtParams);
    }

    protected Map<String, Object> getParametersMap(RuntimeEngine runtime) {
        RuntimeManager manager = ((RuntimeEngineImpl)runtime).getManager();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("ksession", ((InternalRuntimeEngine)runtime).internalGetKieSession());
        try {
            parameters.put("taskService", runtime.getTaskService());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        parameters.put("runtimeManager", manager);
        parameters.put("classLoader", this.getRuntimeManager().getEnvironment().getClassLoader());
        parameters.put("entityManagerFactory", ((InternalRuntimeEngine)runtime).internalGetKieSession().getEnvironment().get("org.kie.api.persistence.jpa.EntityManagerFactory"));
        parameters.put("kieContainer", this.getRuntimeManager().getKieContainer());
        parameters.put("identityProvider", ((SimpleRuntimeEnvironment)this.getRuntimeManager().getEnvironment()).getEnvironmentTemplate().get("org.kie.internal.identity.IdentityProvider"));
        return parameters;
    }

    protected List<TaskLifeCycleEventListener> getTaskListenersFromDescriptor() {
        ArrayList<TaskLifeCycleEventListener> defaultListeners = new ArrayList<TaskLifeCycleEventListener>();
        DeploymentDescriptor descriptor = this.getRuntimeManager().getDeploymentDescriptor();
        if (descriptor != null) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("runtimeManager", this.getRuntimeManager());
            params.put("classLoader", this.getRuntimeManager().getEnvironment().getClassLoader());
            params.put("kieContainer", this.getRuntimeManager().getKieContainer());
            for (ObjectModel model : descriptor.getTaskEventListeners()) {
                Object taskListener = this.getInstanceFromModel(model, this.getRuntimeManager().getEnvironment().getClassLoader(), params);
                if (taskListener == null) continue;
                defaultListeners.add((TaskLifeCycleEventListener)taskListener);
            }
        }
        return defaultListeners;
    }

    protected Map<String, WorkItemHandler> getWorkItemHandlersFromDescriptor(RuntimeEngine runtime) {
        HashMap<String, WorkItemHandler> defaultHandlers = new HashMap<String, WorkItemHandler>();
        DeploymentDescriptor descriptor = this.getRuntimeManager().getDeploymentDescriptor();
        if (descriptor != null) {
            Map<String, Object> params = this.getParametersMap(runtime);
            for (NamedObjectModel model : descriptor.getWorkItemHandlers()) {
                Object hInstance = this.getInstanceFromModel((ObjectModel)model, this.getRuntimeManager().getEnvironment().getClassLoader(), params);
                if (hInstance == null) continue;
                defaultHandlers.put(model.getName(), (WorkItemHandler)hInstance);
            }
        }
        return defaultHandlers;
    }

    protected <T> List<T> getEventListenerFromDescriptor(RuntimeEngine runtime, Class<T> type) {
        ArrayList<Object> listeners = new ArrayList<Object>();
        DeploymentDescriptor descriptor = this.getRuntimeManager().getDeploymentDescriptor();
        if (descriptor != null) {
            Map<String, Object> params = this.getParametersMap(runtime);
            for (ObjectModel model : descriptor.getEventListeners()) {
                Object listenerInstance = this.getInstanceFromModel(model, this.getRuntimeManager().getEnvironment().getClassLoader(), params);
                if (listenerInstance != null && type.isAssignableFrom(listenerInstance.getClass())) {
                    listeners.add(listenerInstance);
                    continue;
                }
                if (!(listenerInstance instanceof Closeable) || listenerInstance instanceof Cacheable) continue;
                ((Closeable)listenerInstance).close();
            }
        }
        return listeners;
    }

    protected Map<String, Object> getGlobalsFromDescriptor(RuntimeEngine runtime) {
        HashMap<String, Object> globals = new HashMap<String, Object>();
        DeploymentDescriptor descriptor = this.getRuntimeManager().getDeploymentDescriptor();
        if (descriptor != null) {
            Map<String, Object> params = this.getParametersMap(runtime);
            for (NamedObjectModel model : descriptor.getGlobals()) {
                Object gInstance = this.getInstanceFromModel((ObjectModel)model, this.getRuntimeManager().getEnvironment().getClassLoader(), params);
                if (gInstance == null) continue;
                globals.put(model.getName(), gInstance);
            }
        }
        return globals;
    }

    protected Properties loadJMSProperties() throws IOException {
        Properties properties = new Properties();
        InputStream input = this.getRuntimeManager().getEnvironment().getClassLoader().getResourceAsStream("/jbpm.audit.jms.properties");
        if (input == null) {
            input = this.getRuntimeManager().getEnvironment().getClassLoader().getResourceAsStream("jbpm.audit.jms.properties");
        }
        properties.load(input);
        return properties;
    }
}

