/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Stream;
import org.kie.server.services.taskassigning.core.model.Group;
import org.kie.server.services.taskassigning.planning.data.LabelValueExtractorRegistry;
import org.kie.server.services.taskassigning.user.system.api.User;

public class UserUtil {
    private UserUtil() {
    }

    public static org.kie.server.services.taskassigning.core.model.User fromExternalUser(User externalUser) {
        org.kie.server.services.taskassigning.core.model.User user = new org.kie.server.services.taskassigning.core.model.User((long)externalUser.getId().hashCode(), externalUser.getId(), true);
        HashSet groups = new HashSet();
        user.setGroups(groups);
        if (externalUser.getGroups() != null) {
            externalUser.getGroups().forEach(externalGroup -> groups.add(new Group((long)externalGroup.getId().hashCode(), externalGroup.getId())));
        }
        user.setAttributes(externalUser.getAttributes());
        LabelValueExtractorRegistry.getInstance().applyLabelValueExtractors(User.class, externalUser, (arg_0, arg_1) -> ((org.kie.server.services.taskassigning.core.model.User)user).setLabelValues(arg_0, arg_1));
        return user;
    }

    public static boolean isUser(String userType) {
        return "User".equals(userType);
    }

    public static Stream<User> filterDuplicates(Collection<User> externalUsers) {
        if (externalUsers == null) {
            return Stream.empty();
        }
        HashSet included = new HashSet();
        return externalUsers.stream().filter(Objects::nonNull).filter(externalUser -> {
            if (!included.contains(externalUser.getId())) {
                included.add(externalUser.getId());
                return true;
            }
            return false;
        });
    }
}

