/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.hardmediumsoft;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class HardMediumSoftScoreHolder
extends AbstractScoreHolder<HardMediumSoftScore> {
    protected final Map<Rule, BiConsumer<RuleContext, Integer>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, Integer>>();
    protected final Map<Rule, BiConsumer<RuleContext, HardMediumSoftScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, HardMediumSoftScore>>();
    protected int hardScore;
    protected int mediumScore;
    protected int softScore;

    public HardMediumSoftScoreHolder(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled, HardMediumSoftScore.ZERO);
    }

    public int getHardScore() {
        return this.hardScore;
    }

    public int getMediumScore() {
        return this.mediumScore;
    }

    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public void configureConstraintWeight(Rule rule, HardMediumSoftScore constraintWeight) {
        super.configureConstraintWeight(rule, constraintWeight);
        BiConsumer<RuleContext, Integer> matchExecutor = constraintWeight.equals(HardMediumSoftScore.ZERO) ? (kcontext, weightMultiplier) -> {} : (constraintWeight.getMediumScore() == 0 && constraintWeight.getSoftScore() == 0 ? (kcontext, weightMultiplier) -> this.addHardConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * weightMultiplier) : (constraintWeight.getHardScore() == 0 && constraintWeight.getSoftScore() == 0 ? (kcontext, weightMultiplier) -> this.addMediumConstraintMatch((RuleContext)kcontext, constraintWeight.getMediumScore() * weightMultiplier) : (constraintWeight.getHardScore() == 0 && constraintWeight.getMediumScore() == 0 ? (kcontext, weightMultiplier) -> this.addSoftConstraintMatch((RuleContext)kcontext, constraintWeight.getSoftScore() * weightMultiplier) : (kcontext, weightMultiplier) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * weightMultiplier, constraintWeight.getMediumScore() * weightMultiplier, constraintWeight.getSoftScore() * weightMultiplier))));
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> this.addMultiConstraintMatch((RuleContext)kcontext, constraintWeight.getHardScore() * weightMultiplier.getHardScore(), constraintWeight.getMediumScore() * weightMultiplier.getMediumScore(), constraintWeight.getSoftScore() * weightMultiplier.getSoftScore()));
    }

    public void penalize(RuleContext kcontext) {
        this.impactScore(kcontext, -1);
    }

    public void penalize(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, -weightMultiplier);
    }

    public void penalize(RuleContext kcontext, int hardWeightMultiplier, int mediumWeightMultiplier, int softWeightMultiplier) {
        this.impactScore(kcontext, -hardWeightMultiplier, -mediumWeightMultiplier, -softWeightMultiplier);
    }

    public void reward(RuleContext kcontext) {
        this.impactScore(kcontext, 1);
    }

    public void reward(RuleContext kcontext, int weightMultiplier) {
        this.impactScore(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, int hardWeightMultiplier, int mediumWeightMultiplier, int softWeightMultiplier) {
        this.impactScore(kcontext, hardWeightMultiplier, mediumWeightMultiplier, softWeightMultiplier);
    }

    @Override
    public void impactScore(RuleContext kcontext) {
        this.impactScore(kcontext, 1);
    }

    @Override
    public void impactScore(RuleContext kcontext, int weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, Integer> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    private void impactScore(RuleContext kcontext, int hardWeightMultiplier, int mediumWeightMultiplier, int softWeightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, HardMediumSoftScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, HardMediumSoftScore.of(hardWeightMultiplier, mediumWeightMultiplier, softWeightMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, int hardWeight) {
        this.hardScore += hardWeight;
        this.registerConstraintMatch(kcontext, () -> this.hardScore -= hardWeight, () -> HardMediumSoftScore.of(hardWeight, 0, 0));
    }

    public void addMediumConstraintMatch(RuleContext kcontext, int mediumWeight) {
        this.mediumScore += mediumWeight;
        this.registerConstraintMatch(kcontext, () -> this.mediumScore -= mediumWeight, () -> HardMediumSoftScore.of(0, mediumWeight, 0));
    }

    public void addSoftConstraintMatch(RuleContext kcontext, int softWeight) {
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> this.softScore -= softWeight, () -> HardMediumSoftScore.of(0, 0, softWeight));
    }

    public void addMultiConstraintMatch(RuleContext kcontext, int hardWeight, int mediumWeight, int softWeight) {
        this.hardScore += hardWeight;
        this.mediumScore += mediumWeight;
        this.softScore += softWeight;
        this.registerConstraintMatch(kcontext, () -> {
            this.hardScore -= hardWeight;
            this.mediumScore -= mediumWeight;
            this.softScore -= softWeight;
        }, () -> HardMediumSoftScore.of(hardWeight, mediumWeight, softWeight));
    }

    @Override
    public HardMediumSoftScore extractScore(int initScore) {
        return HardMediumSoftScore.ofUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }
}

