/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.conferencescheduling.domain;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Set;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.conferencescheduling.domain.TalkType;

public class Timeslot
extends AbstractPersistable {
    private LocalDateTime startDateTime;
    private LocalDateTime endDateTime;
    private Set<TalkType> talkTypeSet;
    private Set<String> tagSet;
    private Integer durationInMinutes;

    public Timeslot() {
    }

    public Timeslot(long id) {
        super(id);
    }

    public LocalDate getDate() {
        return this.startDateTime.toLocalDate();
    }

    public Integer getDurationInMinutes() {
        return this.durationInMinutes;
    }

    public boolean overlapsTime(Timeslot other) {
        if (this == other) {
            return true;
        }
        return this.startDateTime.compareTo(other.endDateTime) < 0 && other.startDateTime.compareTo(this.endDateTime) < 0;
    }

    public int getOverlapInMinutes(Timeslot other) {
        if (this == other) {
            return this.durationInMinutes;
        }
        LocalDateTime startMaximum = this.startDateTime.compareTo(other.startDateTime) < 0 ? other.startDateTime : this.startDateTime;
        LocalDateTime endMinimum = this.endDateTime.compareTo(other.endDateTime) < 0 ? this.endDateTime : other.endDateTime;
        return (int)Duration.between(startMaximum, endMinimum).toMinutes();
    }

    public boolean startsAfter(Timeslot other) {
        return other.endDateTime.compareTo(this.startDateTime) <= 0;
    }

    public boolean endsBefore(Timeslot other) {
        return this.endDateTime.compareTo(other.startDateTime) <= 0;
    }

    public boolean hasTag(String tag) {
        return this.tagSet.contains(tag);
    }

    public boolean isOnSameDayAs(Timeslot other) {
        return this.startDateTime.toLocalDate().equals(other.getStartDateTime().toLocalDate());
    }

    public boolean pauseExists(Timeslot other, int pauseInMinutes) {
        if (this.overlapsTime(other)) {
            return false;
        }
        if (!this.isOnSameDayAs(other)) {
            return true;
        }
        if (this.startsAfter(other)) {
            return this.getStartDateTime().getHour() * 60 + this.getStartDateTime().getMinute() - (other.getEndDateTime().getHour() * 60 + other.getEndDateTime().getMinute()) >= pauseInMinutes;
        }
        return other.getStartDateTime().getHour() * 60 + other.getStartDateTime().getMinute() - (this.getEndDateTime().getHour() * 60 + this.getEndDateTime().getMinute()) >= pauseInMinutes;
    }

    @Override
    public String toString() {
        return this.startDateTime + "-" + this.endDateTime.toLocalTime();
    }

    public LocalDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(LocalDateTime startDateTime) {
        this.startDateTime = startDateTime;
        this.durationInMinutes = startDateTime == null || this.endDateTime == null ? null : Integer.valueOf((int)Duration.between(startDateTime, this.endDateTime).toMinutes());
    }

    public LocalDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
        this.durationInMinutes = this.startDateTime == null || endDateTime == null ? null : Integer.valueOf((int)Duration.between(this.startDateTime, endDateTime).toMinutes());
    }

    public Set<TalkType> getTalkTypeSet() {
        return this.talkTypeSet;
    }

    public void setTalkTypeSet(Set<TalkType> talkTypeSet) {
        this.talkTypeSet = talkTypeSet;
    }

    public Set<String> getTagSet() {
        return this.tagSet;
    }

    public void setTagSet(Set<String> tagSet) {
        this.tagSet = tagSet;
    }

    public Timeslot withTalkTypeSet(Set<TalkType> talkTypeSet) {
        this.talkTypeSet = talkTypeSet;
        return this;
    }

    public Timeslot withStartDateTime(LocalDateTime startDateTime) {
        this.startDateTime = startDateTime;
        this.durationInMinutes = startDateTime == null || this.endDateTime == null ? null : Integer.valueOf((int)Duration.between(startDateTime, this.endDateTime).toMinutes());
        return this;
    }

    public Timeslot withEndDateTime(LocalDateTime endDateTime) {
        this.endDateTime = endDateTime;
        this.durationInMinutes = this.startDateTime == null || endDateTime == null ? null : Integer.valueOf((int)Duration.between(this.startDateTime, endDateTime).toMinutes());
        return this;
    }
}

