/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.meetingscheduling.persistence;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.generator.StringDataGenerator;
import org.optaplanner.examples.meetingscheduling.domain.Attendance;
import org.optaplanner.examples.meetingscheduling.domain.Day;
import org.optaplanner.examples.meetingscheduling.domain.Meeting;
import org.optaplanner.examples.meetingscheduling.domain.MeetingAssignment;
import org.optaplanner.examples.meetingscheduling.domain.MeetingConstraintConfiguration;
import org.optaplanner.examples.meetingscheduling.domain.MeetingSchedule;
import org.optaplanner.examples.meetingscheduling.domain.Person;
import org.optaplanner.examples.meetingscheduling.domain.PreferredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.RequiredAttendance;
import org.optaplanner.examples.meetingscheduling.domain.Room;
import org.optaplanner.examples.meetingscheduling.domain.TimeGrain;
import org.optaplanner.examples.meetingscheduling.persistence.MeetingSchedulingXlsxFileIO;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;

public class MeetingSchedulingGenerator
extends LoggingMain {
    private final StringDataGenerator topicGenerator = new StringDataGenerator().addPart(true, 0, "Strategize", "Fast track", "Cross sell", "Profitize", "Transform", "Engage", "Downsize", "Ramp up", "On board", "Reinvigorate").addPart(false, 1, "data driven", "sales driven", "compelling", "reusable", "negotiated", "sustainable", "laser-focused", "flexible", "real-time", "targeted").addPart(true, 1, "B2B", "e-business", "virtualization", "multitasking", "one stop shop", "braindumps", "data mining", "policies", "synergies", "user experience").addPart(false, 3, "in a nutshell", "in practice", "for dummies", "in action", "recipes", "on the web", "for decision makers", "on the whiteboard", "out of the box", "in the new economy");
    private final int[] durationInGrainsOptions = new int[]{1, 2, 3, 4, 6, 8, 16};
    private final int[] personsPerMeetingOptions = new int[]{2, 3, 4, 5, 6, 8, 10, 12, 14, 16, 20, 30};
    private final int[] startingMinuteOfDayOptions = new int[]{480, 495, 510, 525, 540, 555, 570, 585, 600, 615, 630, 645, 660, 675, 690, 705, 780, 795, 810, 825, 840, 855, 870, 885, 900, 915, 930, 945, 960, 975, 990, 1005, 1020, 1035, 1050, 1065};
    private final StringDataGenerator fullNameGenerator = StringDataGenerator.buildFullNames();
    protected final SolutionFileIO<MeetingSchedule> solutionFileIO = new MeetingSchedulingXlsxFileIO();
    protected final File outputDir = new File(CommonApp.determineDataDir("meetingscheduling"), "unsolved");
    protected Random random;

    public static void main(String[] args) {
        MeetingSchedulingGenerator generator = new MeetingSchedulingGenerator();
        generator.writeMeetingSchedule(50, 5);
        generator.writeMeetingSchedule(100, 5);
        generator.writeMeetingSchedule(200, 5);
        generator.writeMeetingSchedule(400, 5);
        generator.writeMeetingSchedule(800, 5);
    }

    private void writeMeetingSchedule(int meetingListSize, int roomListSize) {
        int timeGrainListSize = meetingListSize * this.durationInGrainsOptions[this.durationInGrainsOptions.length - 1] / roomListSize;
        String fileName = this.determineFileName(meetingListSize, timeGrainListSize, roomListSize);
        File outputFile = new File(this.outputDir, fileName + "." + this.solutionFileIO.getOutputFileExtension());
        MeetingSchedule meetingSchedule = this.createMeetingSchedule(fileName, meetingListSize, timeGrainListSize, roomListSize);
        this.solutionFileIO.write((Object)meetingSchedule, outputFile);
        this.logger.info("Saved: {}", (Object)outputFile);
    }

    private String determineFileName(int meetingListSize, int timeGrainListSize, int roomListSize) {
        return meetingListSize + "meetings-" + timeGrainListSize + "timegrains-" + roomListSize + "rooms";
    }

    public MeetingSchedule createMeetingSchedule(String fileName, int meetingListSize, int timeGrainListSize, int roomListSize) {
        this.random = new Random(37L);
        MeetingSchedule meetingSchedule = new MeetingSchedule();
        meetingSchedule.setId(0L);
        MeetingConstraintConfiguration constraintConfiguration = new MeetingConstraintConfiguration();
        constraintConfiguration.setId(0L);
        meetingSchedule.setConstraintConfiguration(constraintConfiguration);
        this.createMeetingListAndAttendanceList(meetingSchedule, meetingListSize);
        this.createTimeGrainList(meetingSchedule, timeGrainListSize);
        this.createRoomList(meetingSchedule, roomListSize);
        this.createPersonList(meetingSchedule);
        this.linkAttendanceListToPersons(meetingSchedule);
        this.createMeetingAssignmentList(meetingSchedule);
        BigInteger possibleSolutionSize = BigInteger.valueOf((long)timeGrainListSize * (long)roomListSize).pow(meetingSchedule.getMeetingAssignmentList().size());
        this.logger.info("MeetingSchedule {} has {} meetings, {} timeGrains and {} rooms with a search space of {}.", new Object[]{fileName, meetingListSize, timeGrainListSize, roomListSize, AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
        return meetingSchedule;
    }

    private void createMeetingListAndAttendanceList(MeetingSchedule meetingSchedule, int meetingListSize) {
        ArrayList<Meeting> meetingList = new ArrayList<Meeting>(meetingListSize);
        ArrayList<Attendance> globalAttendanceList = new ArrayList<Attendance>();
        long attendanceId = 0L;
        this.topicGenerator.predictMaximumSizeAndReset(meetingListSize);
        for (int i = 0; i < meetingListSize; ++i) {
            Meeting meeting = new Meeting();
            meeting.setId(Long.valueOf(i));
            String topic = this.topicGenerator.generateNextValue();
            meeting.setTopic(topic);
            int durationInGrains = this.durationInGrainsOptions[this.random.nextInt(this.durationInGrainsOptions.length)];
            meeting.setDurationInGrains(durationInGrains);
            int attendanceListSize = this.personsPerMeetingOptions[this.random.nextInt(this.personsPerMeetingOptions.length)];
            int requiredAttendanceListSize = Math.max(2, this.random.nextInt(attendanceListSize + 1));
            ArrayList<RequiredAttendance> requiredAttendanceList = new ArrayList<RequiredAttendance>(requiredAttendanceListSize);
            for (int j = 0; j < requiredAttendanceListSize; ++j) {
                RequiredAttendance attendance = new RequiredAttendance();
                attendance.setId(attendanceId);
                ++attendanceId;
                attendance.setMeeting(meeting);
                requiredAttendanceList.add(attendance);
                globalAttendanceList.add(attendance);
            }
            meeting.setRequiredAttendanceList(requiredAttendanceList);
            int preferredAttendanceListSize = attendanceListSize - requiredAttendanceListSize;
            ArrayList<PreferredAttendance> preferredAttendanceList = new ArrayList<PreferredAttendance>(preferredAttendanceListSize);
            for (int j = 0; j < preferredAttendanceListSize; ++j) {
                PreferredAttendance attendance = new PreferredAttendance();
                attendance.setId(attendanceId);
                ++attendanceId;
                attendance.setMeeting(meeting);
                preferredAttendanceList.add(attendance);
                globalAttendanceList.add(attendance);
            }
            meeting.setPreferredAttendanceList(preferredAttendanceList);
            this.logger.trace("Created meeting with topic ({}), durationInGrains ({}), requiredAttendanceListSize ({}), preferredAttendanceListSize ({}).", new Object[]{topic, durationInGrains, requiredAttendanceListSize, preferredAttendanceListSize});
            meetingList.add(meeting);
        }
        meetingSchedule.setMeetingList(meetingList);
        meetingSchedule.setAttendanceList(globalAttendanceList);
    }

    private void createTimeGrainList(MeetingSchedule meetingSchedule, int timeGrainListSize) {
        ArrayList<Day> dayList = new ArrayList<Day>(timeGrainListSize);
        long dayId = 0L;
        Day day = null;
        ArrayList<TimeGrain> timeGrainList = new ArrayList<TimeGrain>(timeGrainListSize);
        for (int i = 0; i < timeGrainListSize; ++i) {
            TimeGrain timeGrain = new TimeGrain();
            timeGrain.setId(Long.valueOf(i));
            int grainIndex = i;
            timeGrain.setGrainIndex(grainIndex);
            int dayOfYear = i / this.startingMinuteOfDayOptions.length + 1;
            if (day == null || day.getDayOfYear() != dayOfYear) {
                day = new Day();
                day.setId(dayId);
                day.setDayOfYear(dayOfYear);
                ++dayId;
                dayList.add(day);
            }
            timeGrain.setDay(day);
            int startingMinuteOfDay = this.startingMinuteOfDayOptions[i % this.startingMinuteOfDayOptions.length];
            timeGrain.setStartingMinuteOfDay(startingMinuteOfDay);
            this.logger.trace("Created timeGrain with grainIndex ({}), dayOfYear ({}), startingMinuteOfDay ({}).", new Object[]{grainIndex, dayOfYear, startingMinuteOfDay});
            timeGrainList.add(timeGrain);
        }
        meetingSchedule.setDayList(dayList);
        meetingSchedule.setTimeGrainList(timeGrainList);
    }

    private void createRoomList(MeetingSchedule meetingSchedule, int roomListSize) {
        int roomsPerFloor = 20;
        ArrayList<Room> roomList = new ArrayList<Room>(roomListSize);
        for (int i = 0; i < roomListSize; ++i) {
            Room room = new Room();
            room.setId(Long.valueOf(i));
            String name = "R " + (i / 20 * 100 + i % 20 + 1);
            room.setName(name);
            int capacityOptionsSubsetSize = this.personsPerMeetingOptions.length * 3 / 4;
            int capacity = this.personsPerMeetingOptions[this.personsPerMeetingOptions.length - i % capacityOptionsSubsetSize - 1];
            room.setCapacity(capacity);
            this.logger.trace("Created room with name ({}), capacity ({}).", (Object)name, (Object)capacity);
            roomList.add(room);
        }
        meetingSchedule.setRoomList(roomList);
    }

    private void createPersonList(MeetingSchedule meetingSchedule) {
        int attendanceListSize = 0;
        for (Meeting meeting : meetingSchedule.getMeetingList()) {
            attendanceListSize += meeting.getRequiredAttendanceList().size() + meeting.getPreferredAttendanceList().size();
        }
        int personListSize = attendanceListSize * meetingSchedule.getRoomList().size() * 3 / (4 * meetingSchedule.getMeetingList().size());
        ArrayList<Person> personList = new ArrayList<Person>(personListSize);
        this.fullNameGenerator.predictMaximumSizeAndReset(personListSize);
        for (int i = 0; i < personListSize; ++i) {
            Person person = new Person();
            person.setId(Long.valueOf(i));
            String fullName = this.fullNameGenerator.generateNextValue();
            person.setFullName(fullName);
            this.logger.trace("Created person with fullName ({}).", (Object)fullName);
            personList.add(person);
        }
        meetingSchedule.setPersonList(personList);
    }

    private void linkAttendanceListToPersons(MeetingSchedule meetingSchedule) {
        for (Meeting meeting : meetingSchedule.getMeetingList()) {
            ArrayList<Person> availablePersonList = new ArrayList<Person>(meetingSchedule.getPersonList());
            int attendanceListSize = meeting.getRequiredAttendanceList().size() + meeting.getPreferredAttendanceList().size();
            if (availablePersonList.size() < attendanceListSize) {
                throw new IllegalStateException("The availablePersonList size (" + availablePersonList.size() + ") is less than the attendanceListSize (" + attendanceListSize + ").");
            }
            for (RequiredAttendance requiredAttendance : meeting.getRequiredAttendanceList()) {
                requiredAttendance.setPerson((Person)availablePersonList.remove(this.random.nextInt(availablePersonList.size())));
            }
            for (PreferredAttendance preferredAttendance : meeting.getPreferredAttendanceList()) {
                preferredAttendance.setPerson((Person)availablePersonList.remove(this.random.nextInt(availablePersonList.size())));
            }
        }
    }

    private void createMeetingAssignmentList(MeetingSchedule meetingSchedule) {
        List<Meeting> meetingList = meetingSchedule.getMeetingList();
        ArrayList<MeetingAssignment> meetingAssignmentList = new ArrayList<MeetingAssignment>(meetingList.size());
        for (Meeting meeting : meetingList) {
            MeetingAssignment meetingAssignment = new MeetingAssignment();
            meetingAssignment.setId(meeting.getId());
            meetingAssignment.setMeeting(meeting);
            meetingAssignmentList.add(meetingAssignment);
        }
        meetingSchedule.setMeetingAssignmentList(meetingAssignmentList);
    }
}

