/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.solver.move;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.BedDesignation;
import org.optaplanner.examples.pas.domain.PatientAdmissionSchedule;
import org.optaplanner.examples.pas.solver.move.PatientAdmissionMoveHelper;

public class BedChangeMove
extends AbstractMove<PatientAdmissionSchedule> {
    private BedDesignation bedDesignation;
    private Bed toBed;

    public BedChangeMove(BedDesignation bedDesignation, Bed toBed) {
        this.bedDesignation = bedDesignation;
        this.toBed = toBed;
    }

    public boolean isMoveDoable(ScoreDirector<PatientAdmissionSchedule> scoreDirector) {
        return !Objects.equals(this.bedDesignation.getBed(), this.toBed);
    }

    public BedChangeMove createUndoMove(ScoreDirector<PatientAdmissionSchedule> scoreDirector) {
        return new BedChangeMove(this.bedDesignation, this.bedDesignation.getBed());
    }

    protected void doMoveOnGenuineVariables(ScoreDirector<PatientAdmissionSchedule> scoreDirector) {
        PatientAdmissionMoveHelper.moveBed(scoreDirector, this.bedDesignation, this.toBed);
    }

    public BedChangeMove rebase(ScoreDirector<PatientAdmissionSchedule> destinationScoreDirector) {
        return new BedChangeMove((BedDesignation)destinationScoreDirector.lookUpWorkingObject((Object)this.bedDesignation), (Bed)destinationScoreDirector.lookUpWorkingObject((Object)this.toBed));
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.bedDesignation);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toBed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BedChangeMove other = (BedChangeMove)((Object)o);
        return Objects.equals(this.bedDesignation, other.bedDesignation) && Objects.equals(this.toBed, other.toBed);
    }

    public int hashCode() {
        return Objects.hash(this.bedDesignation, this.toBed);
    }

    public String toString() {
        return this.bedDesignation + " {" + this.bedDesignation.getBed() + " -> " + this.toBed + "}";
    }
}

