/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.pmml;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

public enum PMMLConstants {
    KIE_PMML_IMPLEMENTATION("kie-pmml-implementation"),
    LEGACY("legacy"),
    NEW("new");

    private final String name;

    private PMMLConstants(String name) {
        this.name = name;
    }

    public static PMMLConstants byName(String name) {
        return Arrays.stream(PMMLConstants.values()).filter(PMMLConstants.getFilterPredicate(name)).findFirst().orElseThrow(PMMLConstants.getRuntimeExceptionSupplier(name));
    }

    private static Predicate<? super PMMLConstants> getFilterPredicate(String name) {
        return value -> Objects.equals(name, value.name);
    }

    private static Supplier<? extends RuntimeException> getRuntimeExceptionSupplier(String name) {
        return () -> new RuntimeException("Failed to find PMMLConstants with name: " + name);
    }

    public String getName() {
        return this.name;
    }
}

