/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.services.api.model.NodeDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.TimerDesc;

public class ProcessAssetDesc
implements ProcessDefinition {
    private static final long serialVersionUID = -9059086115873165296L;
    private String id;
    private String name;
    private String version;
    private String packageName;
    private String type;
    private String knowledgeType;
    private String namespace;
    private String originalPath;
    private String deploymentId;
    private String encodedProcessSource;
    private Map<String, String> forms = new HashMap<String, String>();
    private List<String> roles = new ArrayList<String>();
    private Collection<String> signals = Collections.emptyList();
    private Collection<String> globals = Collections.emptyList();
    private Collection<String> rules = Collections.emptyList();
    private Map<String, Collection<String>> associatedEntities = new HashMap<String, Collection<String>>();
    private Map<String, String> serviceTasks = new HashMap<String, String>();
    private Map<String, String> processVariables = new HashMap<String, String>();
    private Collection<String> reusableSubProcesses = new ArrayList<String>();
    private Set<NodeDesc> nodes = new HashSet<NodeDesc>();
    private Set<TimerDesc> timers = new HashSet<TimerDesc>();
    private boolean dynamic = true;
    private boolean active = true;

    public ProcessAssetDesc() {
    }

    public ProcessAssetDesc(String id, String name, String version, String packageName, String type, String knowledgeType, String namespace, String deploymentId) {
        this(id, name, version, packageName, type, knowledgeType, namespace, deploymentId, false);
    }

    public ProcessAssetDesc(String id, String name, String version, String packageName, String type, String knowledgeType, String namespace, String deploymentId, boolean dynamic) {
        this.id = this.safeValue(id);
        this.name = this.safeValue(name);
        this.version = this.safeValue(version);
        this.packageName = this.safeValue(packageName);
        this.type = this.safeValue(type);
        this.knowledgeType = this.safeValue(knowledgeType);
        this.namespace = this.safeValue(namespace);
        this.deploymentId = this.safeValue(deploymentId);
        this.dynamic = dynamic;
    }

    private String safeValue(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getKnowledgeType() {
        return this.knowledgeType;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    public void setOriginalPath(String originalPath) {
        this.originalPath = originalPath;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getType() {
        return this.type;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public Map<String, Collection<String>> getAssociatedEntities() {
        return this.associatedEntities;
    }

    public void setAssociatedEntities(Map<String, Collection<String>> associatedEntities) {
        this.associatedEntities = associatedEntities;
    }

    public Map<String, String> getServiceTasks() {
        return this.serviceTasks;
    }

    public void setServiceTasks(Map<String, String> serviceTasks) {
        this.serviceTasks = serviceTasks;
    }

    public Map<String, String> getProcessVariables() {
        return this.processVariables;
    }

    public void setProcessVariables(Map<String, String> processVariables) {
        this.processVariables = processVariables;
    }

    public Collection<String> getReusableSubProcesses() {
        return this.reusableSubProcesses;
    }

    public void setReusableSubProcesses(Collection<String> reusableSubProcesses) {
        this.reusableSubProcesses = reusableSubProcesses;
    }

    public Collection<String> getSignals() {
        return this.signals;
    }

    public void setSignals(Collection<String> signals) {
        this.signals = signals;
    }

    public Collection<String> getGlobals() {
        return this.globals;
    }

    public void setGlobals(Collection<String> globals) {
        this.globals = globals;
    }

    public Collection<String> getReferencedRules() {
        return this.rules;
    }

    public void setReferencedRules(Collection<String> rules) {
        this.rules = rules;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEncodedProcessSource() {
        return this.encodedProcessSource;
    }

    public void setEncodedProcessSource(String processString) {
        this.encodedProcessSource = processString;
    }

    public Map<String, String> getForms() {
        return this.forms;
    }

    public void setForms(Map<String, String> forms) {
        this.forms = forms;
    }

    public void addForm(String id, String formContent) {
        this.forms.put(id, formContent);
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setNodes(Set<NodeDesc> nodes) {
        this.nodes = nodes;
    }

    public Set<NodeDesc> getNodes() {
        return this.nodes;
    }

    public void setTimers(Set<TimerDesc> timers) {
        this.timers = timers;
    }

    public Set<TimerDesc> getTimers() {
        return this.timers;
    }

    public String toString() {
        return "ProcessAssetDesc{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", version='" + this.version + '\'' + ", packageName='" + this.packageName + '\'' + ", type='" + this.type + '\'' + ", knowledgeType='" + this.knowledgeType + '\'' + ", namespace='" + this.namespace + '\'' + ", originalPath='" + this.originalPath + '\'' + ", deploymentId='" + this.deploymentId + '\'' + ", encodedProcessSource='" + this.encodedProcessSource + '\'' + ", forms=" + this.forms + ", roles=" + this.roles + ", signals=" + this.signals + ", globals=" + this.globals + ", rules=" + this.rules + ", associatedEntities=" + this.associatedEntities + ", serviceTasks=" + this.serviceTasks + ", processVariables=" + this.processVariables + ", reusableSubProcesses=" + this.reusableSubProcesses + ", nodes=" + this.nodes + ", timers=" + this.timers + ", dynamic=" + this.dynamic + ", active=" + this.active + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (this.associatedEntities == null ? 0 : this.associatedEntities.hashCode());
        result = 31 * result + (this.deploymentId == null ? 0 : this.deploymentId.hashCode());
        result = 31 * result + (this.encodedProcessSource == null ? 0 : this.encodedProcessSource.hashCode());
        result = 31 * result + (this.forms == null ? 0 : this.forms.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.knowledgeType == null ? 0 : this.knowledgeType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.originalPath == null ? 0 : this.originalPath.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.processVariables == null ? 0 : this.processVariables.hashCode());
        result = 31 * result + (this.reusableSubProcesses == null ? 0 : this.reusableSubProcesses.hashCode());
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.serviceTasks == null ? 0 : this.serviceTasks.hashCode());
        result = 31 * result + (this.signals == null ? 0 : this.signals.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.dynamic ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessAssetDesc other = (ProcessAssetDesc)obj;
        if (this.active != other.active) {
            return false;
        }
        if (this.associatedEntities == null ? other.associatedEntities != null : !this.associatedEntities.equals(other.associatedEntities)) {
            return false;
        }
        if (this.deploymentId == null ? other.deploymentId != null : !this.deploymentId.equals(other.deploymentId)) {
            return false;
        }
        if (this.encodedProcessSource == null ? other.encodedProcessSource != null : !this.encodedProcessSource.equals(other.encodedProcessSource)) {
            return false;
        }
        if (this.forms == null ? other.forms != null : !this.forms.equals(other.forms)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.knowledgeType == null ? other.knowledgeType != null : !this.knowledgeType.equals(other.knowledgeType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        if (this.originalPath == null ? other.originalPath != null : !this.originalPath.equals(other.originalPath)) {
            return false;
        }
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        if (this.processVariables == null ? other.processVariables != null : !this.processVariables.equals(other.processVariables)) {
            return false;
        }
        if (this.reusableSubProcesses == null ? other.reusableSubProcesses != null : !this.reusableSubProcesses.equals(other.reusableSubProcesses)) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        if (this.serviceTasks == null ? other.serviceTasks != null : !this.serviceTasks.equals(other.serviceTasks)) {
            return false;
        }
        if (this.signals == null ? other.signals != null : !this.signals.equals(other.signals)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        return this.dynamic == other.dynamic;
    }

    public ProcessAssetDesc copy() {
        ProcessAssetDesc copied = new ProcessAssetDesc(this.id, this.name, this.version, this.packageName, this.type, this.knowledgeType, this.namespace, this.deploymentId, this.dynamic);
        copied.originalPath = this.originalPath;
        copied.encodedProcessSource = this.encodedProcessSource;
        copied.forms = new HashMap<String, String>(this.forms);
        copied.roles = new ArrayList<String>(this.roles);
        copied.signals = new ArrayList<String>(this.signals);
        copied.globals = new ArrayList<String>(this.globals);
        copied.rules = new ArrayList<String>(this.rules);
        copied.associatedEntities = new HashMap<String, Collection<String>>(this.associatedEntities);
        copied.serviceTasks = new HashMap<String, String>(this.serviceTasks);
        copied.processVariables = new HashMap<String, String>(this.processVariables);
        copied.reusableSubProcesses = new ArrayList<String>(this.reusableSubProcesses);
        copied.active = this.active;
        return copied;
    }
}

