/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.jsbridge.client.perspective;

import java.util.function.Consumer;
import org.uberfire.client.mvp.AbstractWorkbenchPerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.jsbridge.client.perspective.JsWorkbenchPanelConverter;
import org.uberfire.jsbridge.client.perspective.JsWorkbenchPartConverter;
import org.uberfire.jsbridge.client.perspective.jsnative.JsNativeContextDisplay;
import org.uberfire.jsbridge.client.perspective.jsnative.JsNativePanel;
import org.uberfire.jsbridge.client.perspective.jsnative.JsNativePart;
import org.uberfire.jsbridge.client.perspective.jsnative.JsNativePerspective;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.ResourceType;
import org.uberfire.workbench.model.ActivityResourceType;
import org.uberfire.workbench.model.ContextDefinition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.impl.ContextDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.toolbar.ToolBar;

public class JsWorkbenchPerspectiveActivity
extends AbstractWorkbenchPerspectiveActivity {
    private JsNativePerspective realPerspective;
    private final boolean isDefault;

    public JsWorkbenchPerspectiveActivity(JsNativePerspective realPerspective, PlaceManager placeManager, boolean isDefault) {
        super(placeManager);
        this.realPerspective = realPerspective;
        this.isDefault = isDefault;
    }

    public void onStartup(PlaceRequest place) {
        super.onStartup(place);
        this.place = place;
        this.realPerspective.onStartup();
    }

    public void onOpen() {
        super.onOpen();
        this.realPerspective.onOpen();
        this.placeManager.executeOnOpenCallbacks(this.place);
    }

    public void onClose() {
        super.onClose();
        this.realPerspective.onClose();
        this.placeManager.executeOnCloseCallbacks(this.place);
    }

    public void onShutdown() {
        super.onShutdown();
        this.realPerspective.onShutdown();
    }

    public ResourceType getResourceType() {
        return ActivityResourceType.PERSPECTIVE;
    }

    public String getIdentifier() {
        return this.realPerspective.componentId();
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isTransient() {
        return this.realPerspective.isTransient();
    }

    public void getMenus(Consumer<Menus> consumer) {
        consumer.accept(this.realPerspective.menus());
    }

    public ToolBar getToolBar() {
        return this.realPerspective.toolbar();
    }

    public PerspectiveDefinition getDefaultPerspectiveLayout() {
        PerspectiveDefinitionImpl def = new PerspectiveDefinitionImpl(this.realPerspective.defaultPanelType());
        def.setName(this.realPerspective.name());
        JsNativeContextDisplay contextDisplay = this.realPerspective.contextDisplay();
        def.setContextDisplayMode(contextDisplay.mode());
        if (contextDisplay.contextId() != null) {
            def.setContextDefinition((ContextDefinition)new ContextDefinitionImpl((PlaceRequest)new DefaultPlaceRequest(contextDisplay.contextId())));
        }
        PanelDefinition rootPanel = def.getRoot();
        this.realPerspective.view().parts().stream().map(part -> new JsWorkbenchPartConverter((JsNativePart)part).toPartDefinition()).forEach(arg_0 -> ((PanelDefinition)rootPanel).addPart(arg_0));
        this.realPerspective.view().panels().stream().map(panel -> new JsWorkbenchPanelConverter((JsNativePanel)panel).toPanelDefinition()).forEach(panel -> rootPanel.insertChild(panel.getPosition(), panel));
        return def;
    }
}

