/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.model;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;

public class CommitHistory {
    private final List<RevCommit> commits;
    private final Map<AnyObjectId, String> pathsByCommit;
    private final String trackedPath;

    public CommitHistory(List<RevCommit> commits, Map<AnyObjectId, String> pathsByCommit, String trackedPath) {
        this.commits = commits;
        this.pathsByCommit = pathsByCommit;
        this.trackedPath = trackedPath;
    }

    public List<RevCommit> getCommits() {
        return this.commits;
    }

    public String getTrackedFilePath() {
        return this.trackedPath == null ? "/" : this.trackedPath;
    }

    public String trackedFileNameChangeFor(AnyObjectId commitId) {
        return Optional.ofNullable(this.pathsByCommit.get(commitId)).map(path -> "/" + path).orElseGet(() -> this.getTrackedFilePath());
    }
}

