/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.standard;

import java.util.List;
import java.util.stream.Collectors;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.LibraryFileExtensionIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;

@Portable
public class LibraryValueFileExtensionIndexTerm
extends LibraryFileExtensionIndexTerm
implements ValueIndexTerm {
    private List<String> extensions;
    private ValueIndexTerm.TermSearchType searchType;

    public LibraryValueFileExtensionIndexTerm() {
    }

    public LibraryValueFileExtensionIndexTerm(List<String> extensions) {
        this(extensions, ValueIndexTerm.TermSearchType.REGEXP);
    }

    public LibraryValueFileExtensionIndexTerm(List<String> extensions, ValueIndexTerm.TermSearchType searchType) {
        this.extensions = (List)PortablePreconditions.checkNotEmpty((String)"extension", extensions);
        this.searchType = (ValueIndexTerm.TermSearchType)PortablePreconditions.checkNotNull((String)"searchType", (Object)searchType);
    }

    public String getValue() {
        String orQuery = this.extensions.stream().filter(extension -> extension != null && !extension.isEmpty()).collect(Collectors.joining("|"));
        return ".*(" + orQuery + ")";
    }

    public ValueIndexTerm.TermSearchType getSearchType() {
        return this.searchType;
    }
}

