/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class Version
implements Comparable<Version> {
    private static final Version VERSION = Version.getArtifactVersion();
    private final int major;
    private final int minor;
    private final int patchLevel;
    private final String versionString;

    private static Version getArtifactVersion() {
        int major = 0;
        int minor = 0;
        int patchLevel = 0;
        InputStream res = Version.class.getResourceAsStream("/META-INF/maven/org.infinispan.protostream/protostream/pom.properties");
        if (res != null) {
            try {
                Properties pomProps = new Properties();
                pomProps.load(res);
                String version = pomProps.getProperty("version", "0.0.0-UNKNOWN");
                String[] versionParts = version.split("[.\\-]");
                major = Integer.parseInt(versionParts[0]);
                minor = Integer.parseInt(versionParts[1]);
                patchLevel = Integer.parseInt(versionParts[2]);
            }
            catch (IOException | ArrayIndexOutOfBoundsException | NumberFormatException exception) {
                // empty catch block
            }
        }
        return new Version(major, minor, patchLevel);
    }

    public static Version getVersion() {
        return VERSION;
    }

    public static void main(String[] args) {
        System.out.println("ProtoStream version " + Version.getVersion());
    }

    public Version(int major, int minor, int patchLevel) {
        this.major = major;
        this.minor = minor;
        this.patchLevel = patchLevel;
        this.versionString = major + "." + minor + "." + patchLevel;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }

    public String toString() {
        return this.versionString;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return other.major == this.major && other.minor == this.minor && other.patchLevel == this.patchLevel;
    }

    public int hashCode() {
        return 31 * (31 * this.major + this.minor) + this.patchLevel;
    }

    @Override
    public int compareTo(Version other) {
        int d = this.major - other.major;
        if (d == 0 && (d = this.minor - other.minor) == 0) {
            d = this.patchLevel - other.patchLevel;
        }
        return d;
    }
}

