/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.lang.reflect.Field;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.protostream.annotations.impl.DocumentationExtractor;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;

final class ProtoEnumValueMetadata {
    private final int number;
    private final String protoName;
    private final Enum enumValue;
    private final String documentation;

    ProtoEnumValueMetadata(int number, String protoName, Field enumField, Enum enumValue) {
        this.number = number;
        this.protoName = protoName;
        this.enumValue = enumValue;
        this.documentation = DocumentationExtractor.getDocumentation(enumField);
    }

    public int getNumber() {
        return this.number;
    }

    public String getProtoName() {
        return this.protoName;
    }

    public Enum getEnumValue() {
        return this.enumValue;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void generateProto(IndentWriter iw) {
        iw.append("\n");
        ProtoTypeMetadata.appendDocumentation(iw, this.documentation);
        iw.append(this.protoName).append(" = ").append(String.valueOf(this.number));
        if (ProtoSchemaBuilder.generateSchemaDebugComments) {
            iw.append(" /* ").append(this.enumValue.getClass().getCanonicalName()).append('.').append(this.enumValue.name()).append(" */");
        }
        iw.append(";\n");
    }
}

