/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.naming.InitialContext;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.appformer.maven.support.DependencyFilter;
import org.drools.core.impl.InternalKieContainer;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.scanner.KieModuleMetaData;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.Version;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerMode;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Severity;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.KieServerRegistryAware;
import org.kie.server.services.api.StartupStrategy;
import org.kie.server.services.impl.ContainerManager;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerEventSupport;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.impl.StartupStrategyProvider;
import org.kie.server.services.impl.controller.DefaultRestControllerImpl;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.impl.policy.PolicyManager;
import org.kie.server.services.impl.security.JACCIdentityProvider;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.kie.server.services.impl.util.KieServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerImpl
implements KieServer {
    private static final Logger logger = LoggerFactory.getLogger(KieServerImpl.class);
    private static final ServiceLoader<KieServerExtension> serverExtensions = ServiceLoader.load(KieServerExtension.class);
    private static final ServiceLoader<KieServerController> kieControllers = ServiceLoader.load(KieServerController.class);
    private static final ServiceLoader<KieServerStateRepository> serverStateRepos = ServiceLoader.load(KieServerStateRepository.class);
    private KieServerRegistry context;
    private PolicyManager policyManager;
    private KieServerStateRepository repository;
    private String kieServerLocation = System.getProperty("org.kie.server.location", "http://localhost:8230/kie-server/services/rest/server");
    private volatile AtomicBoolean kieServerActive = new AtomicBoolean(false);
    private volatile AtomicBoolean kieServerReady = new AtomicBoolean(false);
    private List<Message> serverMessages = new ArrayList<Message>();
    private Map<String, List<Message>> containerMessages = new ConcurrentHashMap<String, List<Message>>();
    private KieServerEventSupport eventSupport = new KieServerEventSupport();
    protected KieServices ks;
    private long startTimestamp;
    private boolean managementDisabled = Boolean.parseBoolean(System.getProperty("org.kie.server.mgmt.api.disabled", "false"));
    private KieServerMode mode;

    public KieServerImpl() {
        this(new KieServerStateFileRepository());
    }

    public KieServerImpl(KieServerStateRepository stateRepository) {
        this(stateRepository, KieServices.Factory.get());
    }

    public KieServerImpl(KieServerStateRepository stateRepository, KieServices ks) {
        this.repository = stateRepository;
        this.ks = ks;
        String modeParam = System.getProperty("org.kie.server.mode", KieServerMode.DEVELOPMENT.toString());
        try {
            this.mode = KieServerMode.valueOf((String)modeParam.toUpperCase());
            logger.info("Starting server in '" + this.mode.name() + "' mode.");
        }
        catch (Exception ex) {
            this.mode = KieServerMode.DEVELOPMENT;
            logger.warn("Unable to parse value of org.kie.server.mode = " + modeParam + "; supported values are 'DEVELOPMENT' or 'PRODUCTION'. Falling back to 'DEVELOPMENT' mode.");
        }
    }

    public void init() {
        this.init(StartupStrategyProvider.get().getStrategy());
    }

    protected void init(StartupStrategy startupStrategy) {
        logger.info("Selected startup strategy {}", (Object)startupStrategy);
        for (KieServerStateRepository repo : serverStateRepos) {
            if (!repo.getClass().getSimpleName().equals(startupStrategy.getRepositoryType())) continue;
            this.repository = repo;
            break;
        }
        logger.info("Configured '{}' server state repository", (Object)this.repository.getClass().getSimpleName());
        this.context = new KieServerRegistryImpl();
        this.context.registerIdentityProvider(new JACCIdentityProvider());
        this.context.registerStateRepository(this.repository);
        ContainerLocatorProvider.get();
        ContainerManager containerManager = this.getContainerManager();
        KieServerState currentState = this.repository.load(KieServerEnvironment.getServerId());
        List<KieServerExtension> extensions = this.sortKnownExtensions();
        for (KieServerExtension extension : extensions) {
            logger.trace("{} processing", (Object)extension);
            if (!extension.isActive()) continue;
            try {
                extension.init(this, this.context);
                this.context.registerServerExtension(extension);
                if (extension.isInitialized()) {
                    logger.info("{} has been successfully registered as server extension", (Object)extension);
                    continue;
                }
                logger.warn("{} has not been registered as server extension", (Object)extension);
            }
            catch (Exception e) {
                this.serverMessages.add(new Message(Severity.ERROR, "Error when initializing server extension of type " + extension + " due to " + e.getMessage()));
                logger.error("Error when initializing server extension of type {}", (Object)extension, (Object)e);
            }
        }
        this.policyManager = new PolicyManager();
        this.policyManager.start(this, this.context);
        this.kieServerActive.set(true);
        this.eventSupport.fireBeforeServerStarted(this);
        this.startTimestamp = System.currentTimeMillis();
        startupStrategy.startup(this, containerManager, currentState, this.kieServerActive);
        this.eventSupport.fireAfterServerStarted(this);
    }

    public KieServerRegistry getServerRegistry() {
        return this.context;
    }

    public void destroy() {
        this.eventSupport.fireBeforeServerStopped(this);
        this.kieServerActive.set(false);
        this.policyManager.stop();
        KieServerController kieController = this.getDefaultController();
        kieController.disconnect(this.getInfoInternal());
        for (KieServerExtension extension : this.context.getServerExtensions()) {
            try {
                extension.destroy(this, this.context);
                this.context.unregisterServerExtension(extension);
                logger.info("{} has been successfully unregistered as server extension", (Object)extension);
            }
            catch (Exception e) {
                logger.error("Error when destroying server extension of type {}", (Object)extension, (Object)e);
            }
        }
        this.eventSupport.fireAfterServerStopped(this);
    }

    public List<KieServerExtension> getServerExtensions() {
        return this.context.getServerExtensions();
    }

    protected KieServerInfo getInfoInternal() {
        Version version = KieServerEnvironment.getVersion();
        String serverId = KieServerEnvironment.getServerId();
        String serverName = KieServerEnvironment.getServerName();
        String versionStr = version != null ? version.toString() : "Unknown-Version";
        ArrayList<String> capabilities = new ArrayList<String>();
        for (KieServerExtension extension : this.context.getServerExtensions()) {
            capabilities.add(extension.getImplementedCapability());
        }
        return new KieServerInfo(serverId, serverName, versionStr, capabilities, this.kieServerLocation, this.mode);
    }

    @Override
    public ServiceResponse<KieServerInfo> getInfo() {
        try {
            KieServerInfo kieServerInfo = this.getInfoInternal();
            kieServerInfo.setMessages(this.serverMessages);
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Kie Server info", (Object)kieServerInfo);
        }
        catch (Exception e) {
            logger.error("Error retrieving server info:", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error retrieving kie server info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ServiceResponse<KieContainerResource> createContainer(String containerId, KieContainerResource container) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected KieContainerInstanceImpl createContainerInstanceImpl(String containerId, ReleaseId releaseId) {
        return new KieContainerInstanceImpl(containerId, KieContainerStatus.CREATING, null, releaseId, this);
    }

    protected InternalKieContainer createInternalKieContainer(String containerId, ReleaseId releaseId, KieModuleMetaData metadata) {
        return (InternalKieContainer)this.ks.newKieContainer(containerId, (org.kie.api.builder.ReleaseId)releaseId);
    }

    private boolean canBeDeployed(KieContainerInstanceImpl previous) {
        return previous == null || previous.getStatus().equals((Object)KieContainerStatus.FAILED);
    }

    private <T> ServiceResponse<T> validateContainerReleaseAndMode(String preffix, KieContainerResource container) {
        if (container == null) {
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, preffix + " Container is null");
        }
        return this.validateReleaseAndMode(preffix, container.getReleaseId());
    }

    private <T> ServiceResponse<T> validateReleaseAndMode(String preffix, ReleaseId releaseId) {
        if (releaseId == null) {
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, preffix + " Release Id is null");
        }
        boolean isSnapshot = KieServerUtils.isSnapshot(releaseId);
        if (isSnapshot && this.mode.equals((Object)KieServerMode.PRODUCTION)) {
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, preffix + " Kie Server running on PRODUCTION mode doesn't allow deploying SNAPSHOT modules.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<KieContainerResource> activateContainer(String containerId) {
        KieContainerInstanceImpl kieContainerInstanceImpl;
        CopyOnWriteArrayList<Message> messages = new CopyOnWriteArrayList<Message>();
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(containerId);
            if (kci != null && kci.getStatus().equals((Object)KieContainerStatus.DEACTIVATED)) {
                kieContainerInstanceImpl = kci;
                synchronized (kieContainerInstanceImpl) {
                    this.eventSupport.fireBeforeContainerActivated(this, kci);
                    KieModuleMetaData metadata = this.buildKieModuleMetadata(kci.getKieContainer().getReleaseId());
                    Map<String, Object> parameters = this.getContainerParameters(metadata, messages);
                    List<KieServerExtension> extensions = this.context.getServerExtensions();
                    for (KieServerExtension extension : extensions) {
                        extension.activateContainer(containerId, kci, parameters);
                        logger.debug("Container {} (for release id {}) {} activation: DONE", new Object[]{containerId, kci.getKieContainer().getContainerReleaseId(), extension});
                    }
                    kci.setStatus(KieContainerStatus.STARTED);
                    this.storeServerState(currentState -> currentState.getContainers().forEach(containerResource -> {
                        if (containerId.equals(containerResource.getContainerId())) {
                            containerResource.setStatus(KieContainerStatus.STARTED);
                        }
                    }));
                    this.eventSupport.fireAfterContainerActivated(this, kci);
                    this.getDefaultController().update(this.getInternalServerState());
                    messages.add(new Message(Severity.INFO, "Container " + containerId + " activated successfully."));
                    ServiceResponse serviceResponse = new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " activated successfully.", (Object)kci.getResource());
                    return serviceResponse;
                }
            }
            messages.add(new Message(Severity.ERROR, "Container " + containerId + " not found or not in deactivated status."));
        }
        catch (Exception e) {
            messages.add(new Message(Severity.ERROR, "Error activating container '" + containerId + "' due to " + e.getMessage()));
            logger.error("Error activating Container '" + containerId + "'", (Throwable)e);
            kieContainerInstanceImpl = new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error activating container " + containerId + ": " + e.getClass().getName() + ": " + e.getMessage());
            return kieContainerInstanceImpl;
        }
        finally {
            this.containerMessages.put(containerId, messages);
        }
        ServiceResponse serviceResponse = new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Container " + containerId + " not found or not in deactivated status.");
        return serviceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<KieContainerResource> deactivateContainer(String containerId) {
        KieContainerInstanceImpl kieContainerInstanceImpl;
        CopyOnWriteArrayList<Message> messages = new CopyOnWriteArrayList<Message>();
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(containerId);
            if (kci != null && kci.getStatus().equals((Object)KieContainerStatus.STARTED)) {
                kieContainerInstanceImpl = kci;
                synchronized (kieContainerInstanceImpl) {
                    this.eventSupport.fireBeforeContainerDeactivated(this, kci);
                    KieModuleMetaData metadata = this.buildKieModuleMetadata(kci.getKieContainer().getReleaseId());
                    Map<String, Object> parameters = this.getContainerParameters(metadata, messages);
                    List<KieServerExtension> extensions = this.context.getServerExtensions();
                    for (KieServerExtension extension : extensions) {
                        extension.deactivateContainer(containerId, kci, parameters);
                        logger.debug("Container {} (for release id {}) {} deactivation: DONE", new Object[]{containerId, kci.getKieContainer().getContainerReleaseId(), extension});
                    }
                    kci.setStatus(KieContainerStatus.DEACTIVATED);
                    this.storeServerState(currentState -> currentState.getContainers().forEach(containerResource -> {
                        if (containerId.equals(containerResource.getContainerId())) {
                            containerResource.setStatus(KieContainerStatus.DEACTIVATED);
                        }
                    }));
                    this.eventSupport.fireAfterContainerDeactivated(this, kci);
                    this.getDefaultController().update(this.getInternalServerState());
                    messages.add(new Message(Severity.INFO, "Container " + containerId + " deactivated successfully."));
                    ServiceResponse serviceResponse = new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Container " + containerId + " deactivated successfully.", (Object)kci.getResource());
                    return serviceResponse;
                }
            }
            messages.add(new Message(Severity.ERROR, "Container " + containerId + " not found or not in started status."));
        }
        catch (Exception e) {
            messages.add(new Message(Severity.ERROR, "Error deactivating container '" + containerId + "' due to " + e.getMessage()));
            logger.error("Error deactivating Container '" + containerId + "'", (Throwable)e);
            kieContainerInstanceImpl = new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error deactivating container " + containerId + ": " + e.getClass().getName() + ": " + e.getMessage());
            return kieContainerInstanceImpl;
        }
        finally {
            this.containerMessages.put(containerId, messages);
        }
        ServiceResponse serviceResponse = new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Container " + containerId + " not found or not in started status.");
        return serviceResponse;
    }

    @Override
    public ServiceResponse<KieContainerResourceList> listContainers(KieContainerResourceFilter containerFilter) {
        try {
            ArrayList<KieContainerResource> filteredContainers = new ArrayList<KieContainerResource>();
            for (KieContainerResource container : this.getContainersWithMessages()) {
                if (!containerFilter.accept(container)) continue;
                filteredContainers.add(container);
            }
            KieContainerResourceList containerList = new KieContainerResourceList(filteredContainers);
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "List of created containers", (Object)containerList);
        }
        catch (Exception e) {
            logger.error("Error retrieving list of containers", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error listing containers: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    protected List<KieContainerInstanceImpl> getContainers() {
        return this.context.getContainers();
    }

    private List<KieContainerResource> getContainersWithMessages() {
        ArrayList<KieContainerResource> containers = new ArrayList<KieContainerResource>();
        for (KieContainerInstanceImpl instance : this.context.getContainers()) {
            instance.getResource().setMessages(this.getMessagesForContainer(instance.getContainerId()));
            containers.add(instance.getResource());
        }
        return containers;
    }

    @Override
    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        try {
            KieContainerInstanceImpl ci = this.context.getContainer(id);
            if (ci != null) {
                this.setMessages(ci);
                return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Info for container " + id, (Object)ci.getResource());
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving info for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error retrieving container info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private void setMessages(KieContainerInstanceImpl kci) {
        kci.getResource().setMessages(this.getMessagesForContainer(kci.getContainerId()));
    }

    /*
     * Exception decompiling
     */
    @Override
    public ServiceResponse<Void> disposeContainer(String containerId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                KieScannerResource info = this.getScannerResource(kci);
                return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Scanner info successfully retrieved", (Object)info);
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error retrieving scanner info for container '" + id + "'.", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error retrieving scanner info for container '" + id + "': " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private KieScannerResource getScannerResource(KieContainerInstanceImpl kci) {
        return kci.getResource().getScanner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        if (resource == null || resource.getStatus() == null) {
            logger.error("Error updating scanner for container " + id + ". Status is null: " + resource);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error updating scanner for container " + id + ". Status is null: " + resource);
        }
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                KieContainerInstanceImpl kieContainerInstanceImpl = kci;
                synchronized (kieContainerInstanceImpl) {
                    ServiceResponse<KieScannerResource> scannerResponse = this.configureScanner(id, kci, resource);
                    this.storeServerState(currentState -> {
                        String containerId = kci.getContainerId();
                        KieScannerResource scannerState = kci.getResource().getScanner();
                        currentState.getContainers().forEach(containerResource -> {
                            if (containerId.equals(containerResource.getContainerId())) {
                                containerResource.setScanner(scannerState);
                            }
                        });
                    });
                    this.getDefaultController().update(this.getInternalServerState());
                    return scannerResponse;
                }
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error updating scanner for container '" + id + "': " + resource, (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error updating scanner for container '" + id + "': " + resource + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private ServiceResponse<KieScannerResource> configureScanner(String containerId, KieContainerInstanceImpl kci, KieScannerResource scannerResource) {
        ServiceResponse result;
        KieScannerStatus scannerStatus = scannerResource.getStatus();
        switch (scannerStatus) {
            case CREATED: {
                result = this.createScanner(containerId, kci);
                break;
            }
            case STARTED: {
                result = this.startScanner(containerId, scannerResource.getPollInterval(), kci);
                break;
            }
            case STOPPED: {
                result = this.stopScanner(containerId, kci);
                break;
            }
            case SCANNING: {
                result = this.scanNow(containerId, kci);
                break;
            }
            case DISPOSED: {
                result = this.disposeScanner(containerId, kci);
                break;
            }
            default: {
                result = new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Unknown status '" + scannerStatus + "' for scanner on container " + containerId + ".");
            }
        }
        kci.getResource().setScanner((KieScannerResource)result.getResult());
        return result;
    }

    private void storeServerState(Consumer<KieServerState> kieServerStateConsumer) {
        KieServerState currentState = this.repository.load(KieServerEnvironment.getServerId());
        kieServerStateConsumer.accept(currentState);
        this.repository.store(KieServerEnvironment.getServerId(), currentState);
    }

    private ServiceResponse<KieScannerResource> startScanner(String id, Long scannerPollInterval, KieContainerInstanceImpl kci) {
        ServiceResponse<KieScannerResource> response;
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null && KieServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.createScanner(id, kci)).getType())) {
            return response;
        }
        KieScannerStatus scannerStatus = this.mapScannerStatus(kci);
        if (KieScannerStatus.STOPPED.equals((Object)scannerStatus) && scannerPollInterval != null) {
            kci.startScanner(scannerPollInterval);
            messages.add(new Message(Severity.INFO, "Kie scanner successfully started with interval " + scannerPollInterval));
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)this.getScannerResource(kci));
        }
        if (!KieScannerStatus.STOPPED.equals((Object)scannerStatus)) {
            messages.add(new Message(Severity.WARN, "Invalid kie scanner status: " + scannerStatus));
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + scannerStatus, (Object)this.getScannerResource(kci));
        }
        if (scannerPollInterval == null) {
            messages.add(new Message(Severity.WARN, "Invalid polling interval: null"));
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Invalid polling interval: null", (Object)this.getScannerResource(kci));
        }
        messages.add(new Message(Severity.ERROR, "Unknown error starting scanner. Scanner was not started."));
        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Unknown error starting scanner. Scanner was not started.", (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> stopScanner(String id, KieContainerInstanceImpl kci) {
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null) {
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Scanner is not started. ", (Object)this.getScannerResource(kci));
        }
        if (KieScannerStatus.STARTED.equals((Object)this.mapScannerStatus(kci)) || KieScannerStatus.SCANNING.equals((Object)this.mapScannerStatus(kci))) {
            kci.stopScanner();
            messages.add(new Message(Severity.INFO, "Kie scanner successfully stopped."));
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully stopped.", (Object)this.getScannerResource(kci));
        }
        KieScannerStatus scannerStatus = this.mapScannerStatus(kci);
        messages.add(new Message(Severity.WARN, "Invalid kie scanner status: " + scannerStatus));
        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + scannerStatus, (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> scanNow(String id, KieContainerInstanceImpl kci) {
        KieScannerStatus scannerStatus;
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null) {
            this.createScanner(id, kci);
        }
        if (KieScannerStatus.STOPPED.equals((Object)(scannerStatus = this.mapScannerStatus(kci))) || KieScannerStatus.CREATED.equals((Object)scannerStatus) || KieScannerStatus.STARTED.equals((Object)scannerStatus)) {
            kci.scanNow();
            messages.add(new Message(Severity.INFO, "Kie scanner successfully invoked."));
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Scan successfully executed.", (Object)this.getScannerResource(kci));
        }
        messages.add(new Message(Severity.WARN, "Invalid kie scanner status: " + scannerStatus));
        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + scannerStatus, (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> disposeScanner(String id, KieContainerInstanceImpl kci) {
        ServiceResponse<KieScannerResource> response;
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null) {
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Invalid call. Scanner already disposed.", (Object)this.getScannerResource(kci));
        }
        if ((KieScannerStatus.STARTED.equals((Object)this.mapScannerStatus(kci)) || KieScannerStatus.SCANNING.equals((Object)this.mapScannerStatus(kci))) && KieServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.stopScanner(id, kci)).getType())) {
            return response;
        }
        kci.disposeScanner();
        messages.add(new Message(Severity.INFO, "Kie scanner successfully disposed (shut down)."));
        return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully disposed (shut down).", (Object)this.getScannerResource(kci));
    }

    private KieScannerStatus mapScannerStatus(KieContainerInstanceImpl kieContainerInstance) {
        return KieContainerInstanceImpl.mapScannerStatus(kieContainerInstance.getScanner().getStatus());
    }

    private ServiceResponse<KieScannerResource> createScanner(String id, KieContainerInstanceImpl kci) {
        if (kci.getScanner() == null) {
            List<Message> messages = this.getMessagesForContainer(id);
            messages.clear();
            kci.createScanner();
            messages.add(new Message(Severity.INFO, "Kie scanner successfully created."));
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)this.getScannerResource(kci));
        }
        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error creating the scanner for container " + id + ". Scanner already exists.");
    }

    @Override
    public ServiceResponse<ReleaseId> getContainerReleaseId(String id) {
        try {
            KieContainerInstanceImpl ci = this.context.getContainer(id);
            if (ci != null) {
                return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "ReleaseId for container " + id, (Object)ci.getResource().getReleaseId());
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error retrieving container releaseId: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public ServiceResponse<ReleaseId> updateContainerReleaseId(String containerId, ReleaseId releaseId) {
        return this.updateContainerReleaseId(containerId, releaseId, false);
    }

    @Override
    public ServiceResponse<ReleaseId> updateContainerReleaseId(String containerId, ReleaseId releaseId, boolean resetBeforeUpdate) {
        Optional optional = Optional.ofNullable(this.validateReleaseAndMode("Error updating releaseId for container '" + containerId + "'.", releaseId));
        if (optional.isPresent()) {
            ServiceResponse response = optional.get();
            logger.error(response.getMsg());
            return optional.get();
        }
        List<Message> messages = this.getMessagesForContainer(containerId);
        messages.clear();
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(containerId);
            if (kci != null && kci.getKieContainer() != null) {
                KieModuleMetaData metadata = this.buildKieModuleMetadata((org.kie.api.builder.ReleaseId)releaseId);
                Map<String, Object> parameters = this.getReleaseUpdateParameters(metadata, releaseId, kci.getKieContainer(), messages, resetBeforeUpdate);
                List<KieServerExtension> extensions = this.getServerExtensions();
                for (KieServerExtension extension : extensions) {
                    boolean allowed = extension.isUpdateContainerAllowed(containerId, kci, parameters);
                    if (!allowed) {
                        String message = (String)parameters.get("failure-reason");
                        logger.warn("Container {} (for release id {}) on {} cannot be updated due to {}", new Object[]{containerId, releaseId, extension, message});
                        if (messages != null) {
                            messages.add(new Message(Severity.WARN, message));
                        }
                        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, message);
                    }
                    logger.debug("Container {} (for release id {}) on {} ready to be updated", new Object[]{containerId, releaseId, extension});
                }
                this.prepareUpdateExtensions(metadata, kci, releaseId, messages, resetBeforeUpdate);
                ReleaseId originalReleaseId = kci.getResource().getReleaseId();
                Message updateMessage = this.updateKieContainerToVersion(kci, releaseId);
                if (updateMessage.getSeverity().equals((Object)Severity.WARN)) {
                    messages.add(updateMessage);
                    return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error updating release id on container " + containerId + " to " + releaseId, (Object)kci.getResource().getReleaseId());
                }
                this.updateExtensions(metadata, kci, releaseId, messages, resetBeforeUpdate);
                if (messages.stream().anyMatch(m -> m.getSeverity().equals((Object)Severity.ERROR))) {
                    logger.warn("Update of container {} (for release id {}) failed, putting it back to original release id {}", new Object[]{containerId, releaseId, originalReleaseId});
                    updateMessage = this.updateKieContainerToVersion(kci, originalReleaseId);
                    if (updateMessage.getSeverity().equals((Object)Severity.WARN)) {
                        messages.add(updateMessage);
                        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error reverting release id update on container " + containerId + " to original release id " + originalReleaseId, (Object)kci.getResource().getReleaseId());
                    }
                    this.updateExtensions(metadata, kci, originalReleaseId, messages, resetBeforeUpdate);
                    messages.add(new Message(Severity.WARN, "Error updating release id on container " + containerId + " to " + releaseId + ", release id returned back to " + kci.getResource().getReleaseId()));
                    return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error updating release id on container " + containerId + " to " + releaseId + ", release id returned back to " + kci.getResource().getReleaseId(), (Object)kci.getResource().getReleaseId());
                }
                this.storeServerState(currentState -> {
                    ArrayList containers = new ArrayList();
                    currentState.getContainers().forEach(containerResource -> {
                        if (containerId.equals(containerResource.getContainerId())) {
                            containerResource.setReleaseId(releaseId);
                            containerResource.setResolvedReleaseId(new ReleaseId(kci.getKieContainer().getContainerReleaseId()));
                        }
                        containers.add(containerResource);
                    });
                    currentState.setContainers(new HashSet<KieContainerResource>(containers));
                });
                logger.info("Container {} successfully updated to release id {}", (Object)containerId, (Object)releaseId);
                this.ks.getRepository().removeKieModule((org.kie.api.builder.ReleaseId)originalReleaseId);
                this.getDefaultController().update(this.getInternalServerState());
                messages.add(new Message(Severity.INFO, "Release id successfully updated for container " + containerId));
                return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Release id successfully updated.", (Object)kci.getResource().getReleaseId());
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Container " + containerId + " is not instantiated.");
        }
        catch (Exception e) {
            if (messages != null) {
                messages.add(new Message(Severity.WARN, "Error updating releaseId for container '" + containerId + "' due to " + e.getMessage()));
            }
            logger.error("Error updating releaseId for container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + containerId + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private Message updateKieContainerToVersion(KieContainerInstanceImpl kci, ReleaseId releaseId) {
        String containerId = kci.getContainerId();
        Message response = null;
        kci.clearExtraClasses();
        kci.disposeMarshallers();
        Results results = kci.getKieContainer().updateToVersion((org.kie.api.builder.ReleaseId)releaseId);
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            response = new Message(Severity.WARN, "Error updating releaseId for container " + containerId + " to version " + releaseId);
            for (org.kie.api.builder.Message builderMsg : results.getMessages()) {
                response.addMessage(builderMsg.getText());
            }
            logger.error("Error updating releaseId for container " + containerId + " to version " + releaseId + "\nMessages: " + results.getMessages());
        } else {
            kci.updateReleaseId();
            response = new Message(Severity.INFO, "Kie container updated successfully to version " + releaseId);
        }
        return response;
    }

    private void prepareUpdateExtensions(KieModuleMetaData metadata, KieContainerInstanceImpl kci, ReleaseId releaseId, List<Message> messages, boolean resetBeforeUpdate) {
        Map<String, Object> parameters = this.getReleaseUpdateParameters(metadata, releaseId, kci.getKieContainer(), messages, resetBeforeUpdate);
        for (KieServerExtension extension : this.getServerExtensions()) {
            extension.prepareContainerUpdate(kci.getContainerId(), kci, parameters);
            logger.debug("Preparing update for container {} (for release id {}) on {}.", new Object[]{kci.getContainerId(), releaseId, extension});
        }
    }

    private void updateExtensions(KieModuleMetaData metadata, KieContainerInstanceImpl kci, ReleaseId releaseId, List<Message> messages, boolean resetBeforeUpdate) {
        String containerId = kci.getContainerId();
        List<KieServerExtension> extensions = this.getServerExtensions();
        Map<String, Object> parameters = this.getReleaseUpdateParameters(metadata, releaseId, kci.getKieContainer(), messages, resetBeforeUpdate);
        for (KieServerExtension extension : extensions) {
            extension.updateContainer(containerId, kci, parameters);
            logger.debug("Container {} (for release id {}) on {} updated successfully", new Object[]{containerId, releaseId, extension});
        }
    }

    @Override
    public ServiceResponse<KieServerStateInfo> getServerState() {
        KieServerStateInfo state = this.getInternalServerState();
        if (state != null) {
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Successfully loaded server state for server id " + KieServerEnvironment.getServerId(), (Object)state);
        }
        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error when loading server state");
    }

    public KieServerStateInfo getInternalServerState() {
        try {
            KieServerInfo kieServerInfo = this.getInfoInternal();
            KieServerState currentState = this.repository.load(KieServerEnvironment.getServerId());
            KieServerStateInfo stateInfo = new KieServerStateInfo(currentState.getControllers(), currentState.getConfiguration(), currentState.getContainers());
            stateInfo.setServerId(kieServerInfo.getServerId());
            stateInfo.setLocation(kieServerInfo.getLocation());
            return stateInfo;
        }
        catch (Exception e) {
            logger.error("Error when loading server state due to {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    protected KieModuleMetaData buildKieModuleMetadata(org.kie.api.builder.ReleaseId releaseId) {
        return KieModuleMetaData.Factory.newKieModuleMetaData((org.kie.api.builder.ReleaseId)releaseId, (DependencyFilter)DependencyFilter.COMPILE_FILTER);
    }

    public Map<String, Object> getContainerParameters(InternalKieContainer kieContainer, List<Message> messagesForContainer) {
        KieModuleMetaData metadata = this.buildKieModuleMetadata(kieContainer.getReleaseId());
        return this.getContainerParameters(metadata, messagesForContainer);
    }

    protected Map<String, Object> getContainerParameters(KieModuleMetaData metaData, List<Message> messages) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("KieModuleMetaData", metaData);
        parameters.put("ContainerMessages", messages);
        return parameters;
    }

    protected Map<String, Object> getReleaseUpdateParameters(KieModuleMetaData metaData, ReleaseId releaseId, InternalKieContainer kieContainer, List<Message> messages, boolean resetBeforeUpdate) {
        Map<String, Object> parameters = this.getContainerParameters(metaData, messages);
        parameters.put("KieModuleMetaData", metaData);
        if (this.mode.equals((Object)KieServerMode.DEVELOPMENT) && KieServerUtils.isSnapshot(releaseId)) {
            parameters.put("KieServerResetBeforeUpdate", resetBeforeUpdate);
        } else {
            parameters.put("KieServerResetBeforeUpdate", false);
        }
        return parameters;
    }

    protected KieServerController getController() {
        DefaultRestControllerImpl controller = new DefaultRestControllerImpl(this.context);
        try {
            Iterator<KieServerController> it = kieControllers.iterator();
            if (it != null && it.hasNext() && (controller = it.next()) instanceof KieServerRegistryAware) {
                ((KieServerRegistryAware)((Object)controller)).setRegistry(this.context);
            }
        }
        catch (Exception e) {
            logger.debug("Exception when looking up controller implementations {}", (Object)e.getMessage(), (Object)e);
        }
        return controller;
    }

    protected KieServerController getDefaultController() {
        return new DefaultRestControllerImpl(this.context);
    }

    protected ContainerManager getContainerManager() {
        try {
            return (ContainerManager)InitialContext.doLookup("java:module/ContainerManagerEJB");
        }
        catch (Exception e) {
            logger.debug("Unable to find JEE version of ContainerManager suing default one");
            return new ContainerManager();
        }
    }

    protected List<KieServerExtension> sortKnownExtensions() {
        ArrayList<KieServerExtension> extensions = new ArrayList<KieServerExtension>();
        for (KieServerExtension extension : serverExtensions) {
            extensions.add(extension);
        }
        Collections.sort(extensions, new Comparator<KieServerExtension>(){

            @Override
            public int compare(KieServerExtension e1, KieServerExtension e2) {
                return e1.getStartOrder().compareTo(e2.getStartOrder());
            }
        });
        return extensions;
    }

    @Override
    public void addServerMessage(Message message) {
        this.serverMessages.add(message);
    }

    @Override
    public void addContainerMessage(String containerId, Message message) {
        List<Message> messages = this.getMessagesForContainer(containerId);
        messages.add(message);
    }

    public void addServerStatusMessage(KieServerInfo kieServerInfo) {
        StringBuilder serverInfoMsg = new StringBuilder();
        serverInfoMsg.append("Server ").append(kieServerInfo).append("started successfully at ").append(new Date());
        this.serverMessages.add(new Message(Severity.INFO, serverInfoMsg.toString()));
    }

    protected List<Message> getMessagesForContainer(String containerId) {
        List<Message> messages = this.containerMessages.get(containerId);
        if (messages == null) {
            messages = new CopyOnWriteArrayList<Message>();
            this.containerMessages.put(containerId, messages);
        }
        return messages;
    }

    public PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    public boolean isKieServerReady() {
        return this.kieServerReady.get();
    }

    public void markAsReady() {
        this.kieServerReady.set(true);
        logger.info("KieServer {} is ready to receive requests", (Object)KieServerEnvironment.getServerId());
        for (KieServerExtension extension : this.context.getServerExtensions()) {
            try {
                extension.serverStarted();
            }
            catch (Exception e) {
                logger.error("Error when destroying server extension of type {}", (Object)extension, (Object)e);
            }
        }
    }

    public List<Message> healthCheck(boolean report) throws IllegalStateException {
        ArrayList<Message> healthMessages = new ArrayList<Message>();
        long start = System.currentTimeMillis();
        if (!this.isKieServerReady()) {
            healthMessages.add(new Message(Severity.ERROR, String.format("KIE Server '%s' is not ready to serve requests", KieServerEnvironment.getServerId())));
        }
        if (report) {
            Iterator<KieServerExtension> mainInfo = new ArrayList();
            mainInfo.add((KieServerExtension)((Object)String.format("KIE Server '%s' is ready to serve requests %s", KieServerEnvironment.getServerId(), this.isKieServerReady())));
            mainInfo.add((KieServerExtension)((Object)("Server is up for " + this.calculateUptime())));
            Message message = new Message(Severity.INFO, mainInfo);
            healthMessages.add(message);
        }
        for (KieContainerInstance kieContainerInstance : this.getContainers()) {
            if (kieContainerInstance.getStatus().equals((Object)KieContainerStatus.FAILED) && !this.managementDisabled) {
                healthMessages.add(new Message(Severity.WARN, String.format("KIE Container '%s' is in FAILED state", kieContainerInstance.getContainerId())));
                continue;
            }
            if (!kieContainerInstance.getStatus().equals((Object)KieContainerStatus.FAILED) || !this.managementDisabled) continue;
            healthMessages.add(new Message(Severity.ERROR, String.format("KIE Container '%s' is in FAILED state", kieContainerInstance.getContainerId())));
        }
        for (KieServerExtension kieServerExtension : this.getServerExtensions()) {
            List<Message> extensionMessages = kieServerExtension.healthCheck(report);
            healthMessages.addAll(extensionMessages);
        }
        if (report) {
            Message footer = new Message(Severity.INFO, "Health check done in " + (System.currentTimeMillis() - start) + " ms");
            healthMessages.add(footer);
        }
        return healthMessages;
    }

    private String calculateUptime() {
        long different = System.currentTimeMillis() - this.startTimestamp;
        return DurationFormatUtils.formatDurationWords((long)different, (boolean)false, (boolean)false);
    }

    public ServiceResponse<?> checkAccessability() {
        if (this.managementDisabled) {
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "KIE Server management api is disabled");
        }
        return null;
    }

    public String toString() {
        return "KieServer{id='" + KieServerEnvironment.getServerId() + '\'' + "name='" + KieServerEnvironment.getServerName() + '\'' + "version='" + KieServerEnvironment.getVersion() + '\'' + "location='" + this.kieServerLocation + '\'' + '}';
    }

    private static /* synthetic */ void lambda$disposeContainer$8(String containerId, KieServerState currentState) {
        ArrayList containers = new ArrayList();
        currentState.getContainers().forEach(containerResource -> {
            if (!containerId.equals(containerResource.getContainerId())) {
                containers.add(containerResource);
            }
        });
        currentState.setContainers(new HashSet<KieContainerResource>(containers));
    }

    private static /* synthetic */ void lambda$createContainer$2(KieContainerResource container, KieServerState currentState) {
        container.setStatus(KieContainerStatus.FAILED);
        currentState.getContainers().add(container);
    }

    private static /* synthetic */ void lambda$createContainer$1(KieContainerResource container, KieServerState currentState) {
        container.setStatus(KieContainerStatus.STARTED);
        currentState.getContainers().add(container);
    }

    private static /* synthetic */ boolean lambda$createContainer$0(Message m) {
        return m.getSeverity().equals((Object)Severity.ERROR);
    }
}

