/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.jbpm.kie.services.impl.model.ProcessInstanceWithVarsDesc;
import org.jbpm.kie.services.impl.model.UserTaskInstanceWithPotOwnerDesc;
import org.jbpm.services.api.query.model.QueryParam;
import org.jbpm.shared.services.impl.QueryManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.query.QueryContext;

public abstract class AbstractAdvanceRuntimeDataServiceImpl {
    private static final String ID_LIST = "idList";
    private EntityManagerFactory emf;
    private TransactionalCommandService commandService;

    public AbstractAdvanceRuntimeDataServiceImpl() {
        QueryManager.get().addNamedQueries("META-INF/Servicesorm.xml");
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    protected List<org.jbpm.services.api.model.ProcessInstanceWithVarsDesc> queryProcessByVariables(List<QueryParam> attributes, List<QueryParam> processVariables, int processType, String varPrefix, QueryContext queryContext) {
        BiFunction<StringBuilder, StringBuilder, String> mainSQLProducer = (derivedTables, globalWhere) -> "SELECT DISTINCT pil.processInstanceId  FROM ProcessInstanceLog pil \n " + derivedTables + " WHERE  pil.processType = :processType " + globalWhere + " ORDER BY pil.processInstanceId ASC ";
        return this.queryProcessUserTasksByVariables(attributes, processVariables, Collections.emptyList(), Collections.emptyList(), processType, varPrefix, queryContext, mainSQLProducer, this::collectProcessData);
    }

    protected List<org.jbpm.services.api.model.ProcessInstanceWithVarsDesc> queryProcessByVariablesAndTask(List<QueryParam> attributes, List<QueryParam> processVariables, List<QueryParam> taskVariables, List<String> owners, int processType, String varPrefix, QueryContext queryContext) {
        Optional<QueryParam> param = this.findQueryParamMode(attributes);
        BiFunction<StringBuilder, StringBuilder, String> mainSQLProducer = param.isPresent() && param.get().getObjectValue().equals("HISTORY") ? (derivedTables, globalWhere) -> "SELECT DISTINCT pil.processInstanceId  FROM AuditTaskImpl task  INNER JOIN ProcessInstanceLog pil ON pil.processInstanceId = task.processInstanceId \n " + derivedTables + " WHERE  pil.processType = :processType " + globalWhere + " ORDER BY pil.processInstanceId ASC " : (derivedTables, globalWhere) -> "SELECT DISTINCT pil.processInstanceId  FROM Task task  INNER JOIN ProcessInstanceLog pil ON pil.processInstanceId = task.processInstanceId \n " + derivedTables + " WHERE  pil.processType = :processType " + globalWhere + " ORDER BY pil.processInstanceId ASC ";
        return this.queryProcessUserTasksByVariables(attributes, processVariables, taskVariables, owners, processType, varPrefix, queryContext, mainSQLProducer, this::collectProcessData);
    }

    protected List<org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc> queryUserTasksByVariables(List<QueryParam> attributes, List<QueryParam> processVariables, List<QueryParam> taskVariables, List<String> owners, int processType, String varPrefix, QueryContext queryContext) {
        Optional<QueryParam> param = this.findQueryParamMode(attributes);
        if (param.isPresent() && param.get().getObjectValue().equals("HISTORY")) {
            BiFunction<StringBuilder, StringBuilder, String> mainSQLProducer = (derivedTables, globalWhere) -> "SELECT DISTINCT task.taskId as id  FROM AuditTaskImpl task  INNER JOIN ProcessInstanceLog pil ON pil.processInstanceId = task.processInstanceId \n " + derivedTables + " WHERE  pil.processType = :processType " + globalWhere + " ORDER BY task.taskId ASC ";
            return this.queryProcessUserTasksByVariables(attributes, processVariables, taskVariables, owners, processType, varPrefix, queryContext, mainSQLProducer, this::collectHistoryUserTaskData);
        }
        BiFunction<StringBuilder, StringBuilder, String> mainSQLProducer = (derivedTables, globalWhere) -> "SELECT DISTINCT task.id  FROM Task task  INNER JOIN ProcessInstanceLog pil ON pil.processInstanceId = task.processInstanceId \n " + derivedTables + " WHERE  pil.processType = :processType " + globalWhere + " ORDER BY task.id ASC ";
        return this.queryProcessUserTasksByVariables(attributes, processVariables, taskVariables, owners, processType, varPrefix, queryContext, mainSQLProducer, this::collectRuntimeUserTaskData);
    }

    private Optional<QueryParam> findQueryParamMode(List<QueryParam> params) {
        return this.findQueryParamByOperator(params, "MODE");
    }

    private Optional<QueryParam> findQueryParamByOperator(List<QueryParam> params, String specialOperator) {
        return params.stream().filter(e -> e.getOperator().equals(specialOperator)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> List<R> queryProcessUserTasksByVariables(List<QueryParam> attributesArg, List<QueryParam> processVariablesArg, List<QueryParam> taskVariablesArg, List<String> ownersArg, int processType, String varPrefix, QueryContext queryContext, BiFunction<StringBuilder, StringBuilder, String> mainSQLproducer, DataCollector<R> dataCollector) {
        String where;
        ArrayList<QueryParam> attributes = new ArrayList<QueryParam>(attributesArg != null ? attributesArg : Collections.emptyList());
        attributes.removeIf(param -> param.getOperator().equals("MODE"));
        attributes.removeIf(param -> param.getOperator().equals("EXCLUDE"));
        List<Object> processVariables = processVariablesArg != null ? processVariablesArg : Collections.emptyList();
        List<Object> taskVariables = taskVariablesArg != null ? taskVariablesArg : Collections.emptyList();
        List<String> owners = ownersArg != null ? ownersArg : Collections.emptyList();
        StringBuilder globalWhere = new StringBuilder();
        StringBuilder derivedTables = new StringBuilder();
        if (!taskVariables.isEmpty()) {
            where = this.computeVariableExpression(taskVariables, "V", "name", "value");
            derivedTables.append("INNER JOIN (\n    SELECT taskId \n    FROM TaskVariableImpl \n    WHERE " + where + " \n    GROUP BY taskId \n    HAVING COUNT(*) >= :NUMBER_OF_TASKVARS \n) TABLE_TASK_VAR ON TABLE_TASK_VAR.taskId = task.id  \n");
        }
        if (!processVariables.isEmpty()) {
            where = this.computeVariableExpression(processVariables, "P", "A1.variableId", "A1.value");
            derivedTables.append("INNER JOIN (SELECT A1.processInstanceId \nFROM VariableInstanceLog A1 \nLEFT JOIN VariableInstanceLog A2 ON A1.processId = A2.processId AND A1.processInstanceId = A2.processInstanceId AND A1.variableInstanceId = A2.variableInstanceId AND A2.id > A1.id  \nWHERE A2.id IS NULL AND (" + where + ") GROUP BY A1.processInstanceId HAVING COUNT(*) = :NUMBER_OF_PROCVARS ) TABLE_PROC_VAR ON TABLE_PROC_VAR.processInstanceId = pil.processInstanceId \n");
        }
        if (!owners.isEmpty()) {
            derivedTables.append("INNER JOIN ( \n           SELECT DISTINCT po.task_id \n           FROM PeopleAssignments_PotOwners po \n           WHERE po.entity_id IN (:owners) \n           GROUP BY po.task_id \n           HAVING COUNT(po.entity_id) = :num_owners \n) pot ON pot.task_id = task.id ");
        }
        attributes.stream().forEach(expr -> globalWhere.append(" AND " + this.computeExpression((QueryParam)expr, expr.getColumn(), ":ATTR_" + expr.getColumn())));
        String procSQLString = mainSQLproducer.apply(derivedTables, globalWhere);
        List ids = Collections.emptyList();
        EntityManager entityManager = this.emf.createEntityManager();
        try {
            Query query = entityManager.createNativeQuery(procSQLString);
            taskVariables.stream().forEach(var -> {
                String nameParam = this.computeVarNameParameter("V", var.getColumn());
                query.setParameter(nameParam, (Object)var.getColumn());
            });
            taskVariables.stream().filter(e -> e.getObjectValue() != null).forEach(var -> {
                String valueParam = this.computeVarValueParameter((QueryParam)var, "V", var.getColumn());
                query.setParameter(valueParam, var.getObjectValue());
            });
            if (!taskVariables.isEmpty()) {
                query.setParameter("NUMBER_OF_TASKVARS", (Object)taskVariables.stream().map(QueryParam::getColumn).distinct().count());
            }
            processVariables.stream().forEach(var -> {
                String nameParam = this.computeVarNameParameter("P", var.getColumn());
                query.setParameter(nameParam, (Object)(varPrefix + var.getColumn()));
            });
            processVariables.stream().filter(e -> e.getObjectValue() != null).forEach(var -> {
                String valueParam = this.computeVarValueParameter((QueryParam)var, "P", var.getColumn());
                query.setParameter(valueParam, var.getObjectValue());
            });
            if (!processVariables.isEmpty()) {
                query.setParameter("NUMBER_OF_PROCVARS", (Object)processVariables.stream().map(QueryParam::getColumn).distinct().count());
            }
            if (!owners.isEmpty()) {
                List distinctOwners = owners.stream().distinct().collect(Collectors.toList());
                query.setParameter("num_owners", (Object)distinctOwners.size());
                query.setParameter("owners", distinctOwners);
            }
            attributes.stream().filter(e -> e.getObjectValue() != null).forEach(entry -> query.setParameter("ATTR_" + entry.getColumn(), entry.getObjectValue()));
            query.setParameter("processType", (Object)processType);
            this.addPagination(query, queryContext);
            ids = query.getResultList();
            if (ids.isEmpty()) {
                List list = Collections.emptyList();
                return list;
            }
        }
        finally {
            if (entityManager.isOpen()) {
                entityManager.close();
            }
        }
        return dataCollector.apply(ids, varPrefix, attributesArg != null ? attributesArg : Collections.emptyList());
    }

    private List<org.jbpm.services.api.model.ProcessInstanceWithVarsDesc> collectProcessData(List<Number> ids, String varPrefix, List<QueryParam> params) {
        Optional<QueryParam> exclude = this.findQueryParamByOperator(params, "EXCLUDE");
        boolean excludeProcessVariables = exclude.isPresent() && exclude.get().getColumn().equals("ATTR_COLLECTION_VARIABLES");
        List procRows = (List)this.commandService.execute((Command)new QueryNameCommand("GetProcessInstanceByIdList", Collections.singletonMap(ID_LIST, ids)));
        List varRows = !excludeProcessVariables ? (List)this.commandService.execute((Command)new QueryNameCommand("GetVariablesByProcessInstanceIdList", Collections.singletonMap(ID_LIST, ids))) : Collections.emptyList();
        int currentVarIdx = 0;
        ArrayList<org.jbpm.services.api.model.ProcessInstanceWithVarsDesc> data = new ArrayList<org.jbpm.services.api.model.ProcessInstanceWithVarsDesc>();
        for (Object[] row : procRows) {
            ProcessInstanceWithVarsDesc pwv = this.toProcessInstanceWithVarsDesc(row);
            HashMap<String, Object> vars = new HashMap<String, Object>();
            pwv.setVariables(vars);
            HashMap<String, Object> extra = new HashMap<String, Object>();
            pwv.setExtraData(extra);
            while (currentVarIdx < varRows.size() && row[0].equals(((Object[])varRows.get(currentVarIdx))[0])) {
                String name = (String)((Object[])varRows.get(currentVarIdx))[1];
                if (!varPrefix.isEmpty() && name.startsWith(varPrefix)) {
                    extra.put(name.substring(varPrefix.length()), ((Object[])varRows.get(currentVarIdx))[2]);
                } else {
                    vars.put(name, ((Object[])varRows.get(currentVarIdx))[2]);
                }
                ++currentVarIdx;
            }
            data.add(pwv);
        }
        return data;
    }

    private String computeVariableExpression(List<QueryParam> params, String prefix, String varField, String valueField) {
        List vars = params.stream().map(QueryParam::getColumn).distinct().collect(Collectors.toList());
        ArrayList<String> conditions = new ArrayList<String>();
        for (String var : vars) {
            StringBuilder condition = new StringBuilder();
            String nameParam = this.computeVarNameParameter(prefix, var);
            condition.append("(" + varField + " = :" + nameParam);
            List varParams = params.stream().filter(e -> e.getColumn().equals(var)).collect(Collectors.toList());
            varParams.stream().forEach(expr -> {
                String valueParam = this.computeVarValueParameter((QueryParam)expr, prefix, expr.getColumn());
                condition.append(" AND " + this.computeExpression((QueryParam)expr, valueField, ":" + valueParam));
            });
            condition.append(")");
            conditions.add(condition.toString());
        }
        return String.join((CharSequence)" OR ", conditions);
    }

    private String computeVarNameParameter(String prefix, String name) {
        return prefix + "_NAME_" + name;
    }

    private String computeVarValueParameter(QueryParam expr, String prefix, String name) {
        return prefix + "_VALUE_" + expr.getOperator() + "_" + expr.getColumn();
    }

    private String computeExpression(QueryParam expr, String leftOperand, String rightOperand) {
        switch (expr.getOperator()) {
            case "IS_NULL": {
                return leftOperand + " IS NULL ";
            }
            case "NOT_NULL": {
                return leftOperand + " IS NOT NULL ";
            }
            case "IN": {
                return leftOperand + " IN (" + rightOperand + ") ";
            }
            case "NOT_IN": {
                return leftOperand + " NOT IN (" + rightOperand + ") ";
            }
            case "TYPE": {
                return " type = " + rightOperand + " ";
            }
            case "EQUALS_TO": {
                return leftOperand + " = " + rightOperand + " ";
            }
            case "NOT_EQUALS_TO": {
                return leftOperand + " <> " + rightOperand + " ";
            }
            case "LIKE_TO": {
                return leftOperand + " LIKE " + rightOperand + " ";
            }
        }
        throw new UnsupportedOperationException("Queryparam: " + expr + " not supported");
    }

    private ProcessInstanceWithVarsDesc toProcessInstanceWithVarsDesc(Object[] row) {
        return new ProcessInstanceWithVarsDesc(((Number)row[0]).longValue(), (String)row[1], (String)row[2], (String)row[3], ((Number)row[4]).intValue(), (String)row[5], (Date)row[6], (String)row[7], (String)row[8]);
    }

    private void addPagination(Query query, QueryContext context) {
        if (context.getCount() > 0) {
            query.setFirstResult(context.getOffset().intValue());
            query.setMaxResults(context.getCount().intValue());
        }
    }

    private List<org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc> collectRuntimeUserTaskData(List<Number> ids, String varPrefix, List<QueryParam> params) {
        return this.collectUserTaskData("GetTasksByIdList", this::toUserTaskInstanceWithPotOwnerDesc, ids, varPrefix, params);
    }

    private List<org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc> collectHistoryUserTaskData(List<Number> ids, String varPrefix, List<QueryParam> params) {
        return this.collectUserTaskData("GetHistoryTasksByIdList", this::toHistoryUserTaskInstanceWithPotOwnerDesc, ids, varPrefix, params);
    }

    private List<org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc> collectUserTaskData(String taskRetriever, Function<Object[], UserTaskInstanceWithPotOwnerDesc> mapper, List<Number> ids, String varPrefix, List<QueryParam> params) {
        Optional<QueryParam> exclude = this.findQueryParamByOperator(params, "EXCLUDE");
        boolean excludeProcessVariables = exclude.isPresent() && exclude.get().getColumn().equals("ATTR_COLLECTION_VARIABLES");
        List taskRows = (List)this.commandService.execute((Command)new QueryNameCommand(taskRetriever, Collections.singletonMap(ID_LIST, ids)));
        List varRows = (List)this.commandService.execute((Command)new QueryNameCommand("GetTaskVariablesByTaskIdList", Collections.singletonMap(ID_LIST, ids)));
        List potRows = (List)this.commandService.execute((Command)new QueryNameCommand("GetPotentialOwnersByTaskIdList", Collections.singletonMap(ID_LIST, ids)));
        List varProcSQLRows = !excludeProcessVariables ? (List)this.commandService.execute((Command)new QueryNameCommand("GetProcessVariablesByTaskIdList", Collections.singletonMap(ID_LIST, ids))) : Collections.emptyList();
        int currentVarIdx = 0;
        int currentPotIdx = 0;
        int currentVarProcIdx = 0;
        ArrayList<org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc> data = new ArrayList<org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc>();
        for (Object[] row : taskRows) {
            UserTaskInstanceWithPotOwnerDesc pwv = mapper.apply(row);
            while (currentVarIdx < varRows.size() && row[0].equals(((Object[])varRows.get(currentVarIdx))[0])) {
                if (((Number)((Object[])varRows.get(currentVarIdx))[1]).intValue() == 0) {
                    pwv.addInputdata((String)((Object[])varRows.get(currentVarIdx))[2], ((Object[])varRows.get(currentVarIdx))[3]);
                } else {
                    pwv.addOutputdata((String)((Object[])varRows.get(currentVarIdx))[2], ((Object[])varRows.get(currentVarIdx))[3]);
                }
                ++currentVarIdx;
            }
            pwv.getPotentialOwners().clear();
            while (currentPotIdx < potRows.size() && row[0].equals(((Object[])potRows.get(currentPotIdx))[0])) {
                pwv.addPotOwner((String)((Object[])potRows.get(currentPotIdx))[1]);
                ++currentPotIdx;
            }
            while (currentVarProcIdx < varProcSQLRows.size() && row[0].equals(((Object[])varProcSQLRows.get(currentVarProcIdx))[0])) {
                String name = (String)((Object[])varProcSQLRows.get(currentVarProcIdx))[1];
                Object value = ((Object[])varProcSQLRows.get(currentVarProcIdx))[2];
                if (!varPrefix.isEmpty() && name.startsWith(varPrefix)) {
                    pwv.addExtraData(name.substring(varPrefix.length()), value);
                } else {
                    pwv.addProcessVariable(name, value);
                }
                ++currentVarProcIdx;
            }
            data.add(pwv);
        }
        return data;
    }

    private UserTaskInstanceWithPotOwnerDesc toUserTaskInstanceWithPotOwnerDesc(Object[] row) {
        return new UserTaskInstanceWithPotOwnerDesc((Long)((Number)row[0]).longValue(), (String)row[1], (String)row[2], (String)row[3], (String)row[4], (String)null, (String)row[5], (Date)row[6], (String)row[7], (Date)row[8], (Date)null, (String)null, ((Number)row[9]).intValue(), (String)row[10], ((Number)row[11]).longValue(), (String)row[12], (String)row[13], (String)row[14]);
    }

    private UserTaskInstanceWithPotOwnerDesc toHistoryUserTaskInstanceWithPotOwnerDesc(Object[] row) {
        return new UserTaskInstanceWithPotOwnerDesc((Long)((Number)row[0]).longValue(), (String)row[1], (String)null, (String)null, (String)row[2], (String)null, (String)row[3], (Date)row[4], (String)row[5], (Date)null, (Date)null, (String)null, (Integer)null, (String)row[6], ((Number)row[7]).longValue(), (String)row[8], (String)row[9], (String)row[10]);
    }

    protected List<QueryParam> translate(Map<String, String> translationTable, List<QueryParam> attributes) {
        if (attributes == null) {
            return Collections.emptyList();
        }
        ArrayList<QueryParam> translated = new ArrayList<QueryParam>();
        for (QueryParam entry : attributes) {
            String column = translationTable.get(entry.getColumn());
            if (entry.getColumn() != null && entry.getColumn().equals("TASK_OWNER") && this.findQueryParamMode(attributes).isPresent()) {
                column = "task.actualOwner";
            }
            column = column == null ? entry.getColumn() : column;
            translated.add(new QueryParam(column, entry.getOperator(), entry.getValue()));
        }
        return translated;
    }

    @FunctionalInterface
    private static interface DataCollector<T> {
        public List<T> apply(List<Number> var1, String var2, List<QueryParam> var3);
    }
}

