/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.time.LocalDateTime;
import java.util.List;
import org.kie.api.task.model.Status;
import org.kie.server.api.model.taskassigning.PlanningExecutionResult;
import org.kie.server.api.model.taskassigning.PlanningItem;
import org.kie.server.api.model.taskassigning.PlanningItemList;
import org.kie.server.api.model.taskassigning.TaskData;
import org.kie.server.api.model.taskassigning.TaskInputVariablesReadMode;
import org.kie.server.api.model.taskassigning.util.StatusConverter;
import org.kie.server.client.TaskAssigningRuntimeClient;
import org.kie.server.client.util.TaskDataReader;
import org.kie.server.services.taskassigning.planning.util.PropertyUtil;

public class TaskAssigningRuntimeDelegate {
    private final TaskAssigningRuntimeClient runtimeClient;
    private static final int PAGE_SIZE = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.runtimeDelegate.pageSize", 3000, Integer::parseInt);

    public TaskAssigningRuntimeDelegate(TaskAssigningRuntimeClient runtimeClient) {
        this.runtimeClient = runtimeClient;
    }

    public FindTasksResult findTasks(List<Status> status, LocalDateTime fromLastModificationDate, TaskInputVariablesReadMode inputVariablesReadMode) {
        TaskDataReader.Result result = TaskDataReader.from((TaskAssigningRuntimeClient)this.runtimeClient).readTasks(0L, StatusConverter.convertToStringList(status), fromLastModificationDate, PAGE_SIZE, inputVariablesReadMode);
        return new FindTasksResult(result.getQueryTime(), result.getTasks());
    }

    public PlanningExecutionResult executePlanning(List<PlanningItem> planningItems, String userId) {
        return this.runtimeClient.executePlanning(new PlanningItemList(planningItems), userId);
    }

    static class FindTasksResult {
        private LocalDateTime queryTime;
        private List<TaskData> tasks;

        public LocalDateTime getQueryTime() {
            return this.queryTime;
        }

        public List<TaskData> getTasks() {
            return this.tasks;
        }

        public FindTasksResult(LocalDateTime queryTime, List<TaskData> tasks) {
            this.queryTime = queryTime;
            this.tasks = tasks;
        }
    }
}

