/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.storage;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.server.controller.impl.storage.FileBasedKieServerTemplateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerStorageFileWatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ControllerStorageFileWatcher.class);
    public static final String STORAGE_FILE_WATCHER_INTERVAL = "org.kie.server.controller.templatefile.watcher.interval";
    private long sleepTime = Long.parseLong(System.getProperty("org.kie.server.controller.templatefile.watcher.interval", "30000"));
    private Path toWatch;
    private AtomicBoolean active = new AtomicBoolean(true);
    private String templateFileName;
    private long lastUpdate = -1L;
    private FileBasedKieServerTemplateStorage storage;

    public ControllerStorageFileWatcher(String configFilePath, FileBasedKieServerTemplateStorage storage) {
        this.toWatch = Paths.get(configFilePath, new String[0]);
        this.templateFileName = this.toWatch.toFile().getName();
        this.storage = storage;
        if (!Files.isDirectory(this.toWatch, new LinkOption[0])) {
            this.toWatch = Paths.get(configFilePath, new String[0]).getParent();
        }
        this.toWatch = Paths.get(this.toWatch.toString(), this.templateFileName);
        try {
            this.lastUpdate = Files.getLastModifiedTime(this.toWatch, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            log.error("Unable to read last modified date of controller template file", (Throwable)e);
        }
    }

    public void stop() {
        this.active.set(false);
    }

    @Override
    public void run() {
        try {
            while (this.active.get()) {
                FileTime lastModified = Files.getLastModifiedTime(this.toWatch, new LinkOption[0]);
                log.debug("Config file " + this.toWatch + " last modified " + lastModified);
                if (lastModified.toMillis() > this.lastUpdate) {
                    log.debug("Template file updated, reloading...");
                    try (FileReader reader = new FileReader(this.toWatch.toFile());){
                        this.storage.loadTemplateMapsFromFile();
                        log.info("Successfully reloaded server templates from file");
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception while reading updated template file :: " + e.getMessage(), (Throwable)e);
                    }
                    this.lastUpdate = lastModified.toMillis();
                }
                Thread.sleep(this.sleepTime);
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted exception received...");
        }
        catch (IOException e1) {
            log.warn("Unexpected exception while watching template file", (Throwable)e1);
        }
    }
}

