/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.admin.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseInstanceList;
import org.kie.server.api.model.cases.CaseMigrationReportInstance;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.admin.CaseAdminServicesClient;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class CaseAdminServicesClientImpl
extends AbstractKieServicesClientImpl
implements CaseAdminServicesClient {
    public CaseAdminServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public CaseAdminServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public List<CaseInstance> getCaseInstances(Integer page, Integer pageSize) {
        return this.getCaseInstances(null, page, pageSize, "", true);
    }

    @Override
    public List<CaseInstance> getCaseInstances(List<String> status, Integer page, Integer pageSize) {
        return this.getCaseInstances(status, page, pageSize, "", true);
    }

    @Override
    public List<CaseInstance> getCaseInstances(Integer page, Integer pageSize, String sort, boolean sortOrder) {
        return this.getCaseInstances(null, page, pageSize, sort, sortOrder);
    }

    @Override
    public List<CaseInstance> getCaseInstances(List<String> status, Integer page, Integer pageSize, String sort, boolean sortOrder) {
        CaseInstanceList list = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("", page, pageSize);
            queryString = this.getAdditionalParams(queryString, "status", status);
            queryString = this.getSortingQueryString(queryString, sort, sortOrder);
            list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/cases/instances", valuesMap) + queryString, CaseInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseQueryService", "getCaseInstances", new Object[]{this.safeList(status), page, pageSize, sort, sortOrder})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            list = (CaseInstanceList)response.getResult();
        }
        if (list != null) {
            return list.getItems();
        }
        return Collections.emptyList();
    }

    @Override
    public CaseMigrationReportInstance migrateCaseInstance(String containerId, String caseId, String targetContainerId, Map<String, String> processMapping) {
        return this.migrateCaseInstance(containerId, caseId, targetContainerId, processMapping, new HashMap<String, String>());
    }

    @Override
    public CaseMigrationReportInstance migrateCaseInstance(String containerId, String caseId, String targetContainerId, Map<String, String> processMapping, Map<String, String> nodeMapping) {
        CaseMigrationReportInstance report = null;
        HashMap<String, Map<String, String>> mappings = new HashMap<String, Map<String, String>>();
        mappings.put("ProcessMapping", processMapping);
        mappings.put("NodeMapping", nodeMapping);
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("containerId", containerId);
            valuesMap.put("caseId", caseId);
            String queryString = "?targetContainerId=" + targetContainerId;
            report = this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"admin/containers/{containerId}/cases/instances/{caseId}", valuesMap) + queryString, this.serialize(mappings), CaseMigrationReportInstance.class, new HashMap<String, String>());
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("CaseAdminService", "migrateCaseInstance", this.serialize(this.safeMap(mappings)), this.marshaller.getFormat().getType(), new Object[]{containerId, caseId, targetContainerId})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "CaseMgmt").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            report = (CaseMigrationReportInstance)response.getResult();
        }
        return report;
    }
}

