/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.core.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kie.api.KieBase;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.models.PMMLModel;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.evaluator.api.executor.PMMLRuntimeInternal;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluator;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluatorFinderImpl;
import org.kie.pmml.evaluator.core.utils.KnowledgeBaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLRuntimeInternalImpl
implements PMMLRuntimeInternal {
    private static final Logger logger = LoggerFactory.getLogger(PMMLRuntimeInternalImpl.class);
    private final KieBase knowledgeBase;
    private final PMMLModelEvaluatorFinderImpl pmmlModelExecutorFinder;

    public PMMLRuntimeInternalImpl(KieBase knowledgeBase, PMMLModelEvaluatorFinderImpl pmmlModelExecutorFinder) {
        this.knowledgeBase = knowledgeBase;
        this.pmmlModelExecutorFinder = pmmlModelExecutorFinder;
    }

    public KieBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    public List<KiePMMLModel> getKiePMMLModels() {
        return KnowledgeBaseUtils.getModels(this.knowledgeBase);
    }

    public List<PMMLModel> getPMMLModels() {
        List<KiePMMLModel> kiePMMLModels = this.getKiePMMLModels();
        return new ArrayList<KiePMMLModel>(kiePMMLModels);
    }

    public Optional<KiePMMLModel> getKiePMMLModel(String modelName) {
        return KnowledgeBaseUtils.getModel(this.knowledgeBase, modelName);
    }

    public Optional<PMMLModel> getPMMLModel(String modelName) {
        return this.getKiePMMLModel(modelName).map(KiePMMLModel.class::cast);
    }

    public PMML4Result evaluate(String modelName, PMMLContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("evaluate {} {}", (Object)modelName, (Object)context);
        }
        KiePMMLModel toEvaluate = this.getKiePMMLModel(modelName).orElseThrow(() -> new KiePMMLException("Failed to retrieve model with name " + modelName));
        return this.evaluate(toEvaluate, context);
    }

    protected PMML4Result evaluate(KiePMMLModel model, PMMLContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("evaluate {} {}", (Object)model, (Object)context);
        }
        this.addMissingValuesReplacements(model, context);
        this.executeTransformations(model, context);
        PMMLModelEvaluator executor = this.getFromPMMLModelType(model.getPmmlMODEL()).orElseThrow(() -> new KiePMMLException(String.format("PMMLModelEvaluator not found for model %s", model.getPmmlMODEL())));
        return executor.evaluate(this.knowledgeBase, model, context);
    }

    protected void addMissingValuesReplacements(KiePMMLModel model, PMMLContext context) {
        logger.debug("addMissingValuesReplacements {} {}", (Object)model, (Object)context);
        PMMLRequestData requestData = context.getRequestData();
        Map mappedRequestParams = requestData.getMappedRequestParams();
        Map missingValueReplacementMap = model.getMissingValueReplacementMap();
        missingValueReplacementMap.forEach((fieldName, missingValueReplacement) -> {
            if (!mappedRequestParams.containsKey(fieldName)) {
                logger.debug("missingValueReplacement {} {}", fieldName, missingValueReplacement);
                requestData.addRequestParam(fieldName, missingValueReplacement);
                context.addMissingValueReplaced(fieldName, missingValueReplacement);
            }
        });
    }

    protected void executeTransformations(KiePMMLModel model, PMMLContext context) {
        logger.debug("executeTransformations {} {}", (Object)model, (Object)context);
        PMMLRequestData requestData = context.getRequestData();
        Map mappedRequestParams = requestData.getMappedRequestParams();
        List<KiePMMLNameValue> kiePMMLNameValues = this.getKiePMMLNameValuesFromParameterInfos(mappedRequestParams.values());
        Map commonTransformationsMap = model.getCommonTransformationsMap();
        commonTransformationsMap.forEach((fieldName, transformationFunction) -> {
            if (!mappedRequestParams.containsKey(fieldName)) {
                logger.debug("commonTransformation {} {}", fieldName, transformationFunction);
                Object commonTranformation = transformationFunction.apply(kiePMMLNameValues);
                requestData.addRequestParam(fieldName, commonTranformation);
                context.addCommonTranformation(fieldName, commonTranformation);
                kiePMMLNameValues.add(new KiePMMLNameValue(fieldName, commonTranformation));
            }
        });
        Map localTransformationsMap = model.getLocalTransformationsMap();
        localTransformationsMap.forEach((fieldName, transformationFunction) -> {
            logger.debug("localTransformation {} {}", fieldName, transformationFunction);
            Object localTransformation = transformationFunction.apply(kiePMMLNameValues);
            if (mappedRequestParams.containsKey(fieldName)) {
                ParameterInfo toRemove = (ParameterInfo)mappedRequestParams.get(fieldName);
                requestData.removeRequestParam(toRemove);
            }
            requestData.addRequestParam(fieldName, localTransformation);
            context.addLocalTranformation(fieldName, localTransformation);
        });
    }

    private Optional<PMMLModelEvaluator> getFromPMMLModelType(PMML_MODEL pmmlMODEL) {
        logger.trace("getFromPMMLModelType {}", (Object)pmmlMODEL);
        return this.pmmlModelExecutorFinder.getImplementations(false).stream().filter(implementation -> pmmlMODEL.equals((Object)implementation.getPMMLModelType())).findFirst();
    }

    private List<KiePMMLNameValue> getKiePMMLNameValuesFromParameterInfos(Collection<ParameterInfo> parameterInfos) {
        return parameterInfos.stream().map(parameterInfo -> new KiePMMLNameValue(parameterInfo.getName(), parameterInfo.getValue())).collect(Collectors.toList());
    }
}

