/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.impl;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.drools.model.EntryPoint;
import org.drools.model.WindowDefinition;
import org.drools.model.WindowReference;
import org.drools.model.functions.Predicate1;
import org.drools.model.impl.AbstractWindow;
import org.drools.model.impl.ModelComponent;
import org.drools.model.impl.NamesGenerator;

public class WindowReferenceImpl<T>
extends AbstractWindow
implements WindowReference<T>,
ModelComponent {
    private final Class<T> patternType;
    private final Predicate1<T>[] predicates;
    private final String name;
    private final EntryPoint entryPoint;

    public WindowReferenceImpl(WindowDefinition.Type type, long value, Class<T> patternType, Predicate1<T> ... predicates) {
        this(type, value, null, patternType, predicates);
    }

    public WindowReferenceImpl(WindowDefinition.Type type, long value, Class<T> patternType, EntryPoint entryPoint, Predicate1<T> ... predicates) {
        this(type, value, null, patternType, entryPoint, predicates);
    }

    public WindowReferenceImpl(WindowDefinition.Type type, long value, TimeUnit timeUnit, Class<T> patternType, Predicate1<T> ... predicates) {
        this(type, value, timeUnit, patternType, (EntryPoint)null, predicates);
    }

    public WindowReferenceImpl(WindowDefinition.Type type, long value, TimeUnit timeUnit, Class<T> patternType, EntryPoint entryPoint, Predicate1<T> ... predicates) {
        super(type, value, timeUnit);
        this.patternType = patternType;
        this.predicates = predicates;
        this.entryPoint = entryPoint;
        this.name = NamesGenerator.generateName("window");
    }

    @Override
    public Class<T> getPatternType() {
        return this.patternType;
    }

    @Override
    public Predicate1<T>[] getPredicates() {
        return this.predicates;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public boolean isEqualTo(ModelComponent o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowReferenceImpl)) {
            return false;
        }
        WindowReferenceImpl that = (WindowReferenceImpl)o;
        if (!super.isEqualTo(that)) {
            return false;
        }
        if (this.patternType != null ? !this.patternType.equals(that.patternType) : that.patternType != null) {
            return false;
        }
        if (!Arrays.equals(this.predicates, that.predicates)) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }
}

