/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Model;
import org.drools.model.impl.ModelImpl;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.stream.ConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraint;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintSessionFactory;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsFromUniConstraintStream;

public final class DroolsConstraintFactory<Solution_>
implements InnerConstraintFactory<Solution_> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final String defaultConstraintPackage;
    private final AtomicLong createdVariableCounter = new AtomicLong();

    public DroolsConstraintFactory(SolutionDescriptor<Solution_> solutionDescriptor) {
        Package pack;
        this.solutionDescriptor = solutionDescriptor;
        ConstraintConfigurationDescriptor<Solution_> configurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        this.defaultConstraintPackage = configurationDescriptor == null ? ((pack = solutionDescriptor.getSolutionClass().getPackage()) == null ? "" : pack.getName()) : configurationDescriptor.getConstraintPackage();
    }

    @Override
    public <A> UniConstraintStream<A> fromUnfiltered(Class<A> fromClass) {
        return new DroolsFromUniConstraintStream(this, fromClass);
    }

    @Override
    public ConstraintSessionFactory<Solution_> buildSessionFactory(Constraint[] constraints) {
        ModelImpl model = new ModelImpl();
        AbstractScoreHolder scoreHolder = (AbstractScoreHolder)this.solutionDescriptor.getScoreDefinition().buildScoreHolder(false);
        Class<?> scoreHolderClass = scoreHolder.getClass();
        Package pack = this.solutionDescriptor.getSolutionClass().getPackage();
        Global scoreHolderGlobal = DSL.globalOf(scoreHolderClass, (String)(pack == null ? "" : pack.getName()), (String)"scoreHolder");
        model.addGlobal(scoreHolderGlobal);
        ArrayList droolsConstraintList = new ArrayList(constraints.length);
        HashSet<String> constraintIdSet = new HashSet<String>(constraints.length);
        for (Constraint constraint : constraints) {
            if (constraint.getConstraintFactory() != this) {
                throw new IllegalStateException("The constraint (" + constraint.getConstraintId() + ") must be created from the same constraintFactory.");
            }
            boolean added = constraintIdSet.add(constraint.getConstraintId());
            if (!added) {
                throw new IllegalStateException("There are 2 constraints with the same constraintName (" + constraint.getConstraintName() + ") in the same constraintPackage (" + constraint.getConstraintPackage() + ").");
            }
            DroolsConstraint droolsConstraint = (DroolsConstraint)constraint;
            droolsConstraintList.add(droolsConstraint);
            model.addRule(droolsConstraint.createRule(scoreHolderGlobal));
        }
        return new DroolsConstraintSessionFactory<Solution_>(this.solutionDescriptor, (Model)model, droolsConstraintList);
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public LongSupplier getVariableIdSupplier() {
        return this.createdVariableCounter::incrementAndGet;
    }

    @Override
    public String getDefaultConstraintPackage() {
        return this.defaultConstraintPackage;
    }
}

