/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLSimplePredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLReasonCodeAndValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLCompoundPredicateWithAccumulationASTFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLCompoundPredicateWithAccumulationASTFactory.class.getName());

    public static void declareRuleFromCompoundPredicateSurrogate(PredicateASTFactoryData predicateASTFactoryData, String agendaActivationGroup, Number toAccumulate, String statusToSet, KiePMMLReasonCodeAndValue reasonCodeAndValue, boolean isLastCharacteristic) {
        logger.trace("declareRuleFromCompoundPredicateSurrogate {} {} {} {} {}", new Object[]{predicateASTFactoryData, agendaActivationGroup, toAccumulate, statusToSet, isLastCharacteristic});
        CompoundPredicate compoundPredicate = (CompoundPredicate)predicateASTFactoryData.getPredicate();
        List<Predicate> simplePredicates = compoundPredicate.getPredicates().stream().filter(predicate -> predicate instanceof SimplePredicate).collect(Collectors.toList());
        simplePredicates.forEach(predicate -> {
            SimplePredicate simplePredicate = (SimplePredicate)predicate;
            PredicateASTFactoryData newPredicateASTFactoryData = predicateASTFactoryData.cloneWithPredicate((Predicate)simplePredicate);
            KiePMMLSimplePredicateASTFactory.factory(newPredicateASTFactoryData).declareRuleFromSimplePredicateSurrogate(agendaActivationGroup, toAccumulate, statusToSet, reasonCodeAndValue, isLastCharacteristic);
        });
    }

    public static void declareRuleFromCompoundPredicateAndOrXor(KiePMMLDroolsRule.Builder builder, List<KiePMMLDroolsRule> rules, KiePMMLReasonCodeAndValue reasonCodeAndValue, boolean isLastCharacteristic) {
        logger.trace("declareRuleFromCompoundPredicateAndOrXor {} {} {}", new Object[]{builder, rules, isLastCharacteristic});
        if (isLastCharacteristic) {
            builder = builder.withAccumulationResult(true).withResultCode(ResultCode.OK);
        }
        if (reasonCodeAndValue != null) {
            builder = builder.withReasonCodeAndValue(reasonCodeAndValue);
        }
        rules.add(builder.build());
    }
}

