/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scorecards;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.util.StringUtils;

public class StringUtil {
    public static boolean isNumericWithOperators(CharSequence cs) {
        if (cs == null) {
            return false;
        }
        String allowedCharsInNumeric = "<>=- ";
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            char ch = cs.charAt(i);
            if (Character.isDigit(ch) || allowedCharsInNumeric.indexOf(ch) > -1) continue;
            return false;
        }
        return true;
    }

    public static String unescapeXML(String xml) {
        Pattern xmlEntityRegex = Pattern.compile("&(#?)([^;]+);");
        StringBuffer unescapedOutput = new StringBuffer(xml.length());
        Matcher m = xmlEntityRegex.matcher(xml);
        Map<String, String> builtinEntities = null;
        while (m.find()) {
            String entity;
            String ent = m.group(2);
            String hashmark = m.group(1);
            if (hashmark != null && hashmark.length() > 0) {
                int code = Integer.parseInt(ent);
                entity = Character.toString((char)code);
            } else {
                if (builtinEntities == null) {
                    builtinEntities = StringUtil.buildBuiltinXMLEntityMap();
                }
                if ((entity = builtinEntities.get(ent)) == null) {
                    entity = "&" + ent + ';';
                }
            }
            m.appendReplacement(unescapedOutput, entity);
        }
        m.appendTail(unescapedOutput);
        return unescapedOutput.toString();
    }

    private static Map<String, String> buildBuiltinXMLEntityMap() {
        HashMap<String, String> entities = new HashMap<String, String>(10);
        entities.put("lt", "<");
        entities.put("gt", ">");
        entities.put("amp", "&");
        entities.put("apos", "'");
        entities.put("quot", "\"");
        return entities;
    }

    public static int countMatches(String str, String sub) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }
}

