/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.chained;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChain {
    private final List<Object> entityList;

    public SubChain(List<Object> entityList) {
        this.entityList = entityList;
    }

    public List<Object> getEntityList() {
        return this.entityList;
    }

    public Object getFirstEntity() {
        if (this.entityList.isEmpty()) {
            return null;
        }
        return this.entityList.get(0);
    }

    public Object getLastEntity() {
        if (this.entityList.isEmpty()) {
            return null;
        }
        return this.entityList.get(this.entityList.size() - 1);
    }

    public int getSize() {
        return this.entityList.size();
    }

    public SubChain reverse() {
        ArrayList<Object> reversedEntityList = new ArrayList<Object>(this.entityList);
        Collections.reverse(reversedEntityList);
        return new SubChain(reversedEntityList);
    }

    public SubChain subChain(int fromIndex, int toIndex) {
        return new SubChain(this.entityList.subList(fromIndex, toIndex));
    }

    public <Solution_> SubChain rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        ArrayList<Object> rebasedEntityList = new ArrayList<Object>(this.entityList.size());
        for (Object entity : this.entityList) {
            rebasedEntityList.add(destinationScoreDirector.lookUpWorkingObject(entity));
        }
        return new SubChain(rebasedEntityList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChain) {
            SubChain other = (SubChain)o;
            return this.entityList.equals(other.entityList);
        }
        return false;
    }

    public int hashCode() {
        return this.entityList.hashCode();
    }

    public String toString() {
        return this.entityList.toString();
    }

    public String toDottedString() {
        return "[" + this.getFirstEntity() + ".." + this.getLastEntity() + "]";
    }
}

