/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import java.util.NoSuchElementException;
import org.drools.ancompiler.NetworkHandlerAdaptor;
import org.drools.core.common.BaseNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.Sink;
import org.drools.core.rule.ContextEntry;
import org.drools.core.util.index.AlphaRangeIndex;

abstract class AbstractCompilerHandler
extends NetworkHandlerAdaptor {
    protected static final String NEWLINE = "\n";
    private static final String MAP_VARIABLE_NAME_SUFFIX = "ToNodeId";
    protected static final String RANGE_INDEX_VARIABLE_NAME_PREFIX = "rangeIndex";

    AbstractCompilerHandler() {
    }

    protected static Class<?> getVariableType(AlphaNode alphaNode) {
        return alphaNode.getConstraint().getClass();
    }

    protected static Class<?> getVariableType(Sink sink) {
        return sink.getClass();
    }

    protected static String getVariableName(AlphaNode alphaNode) {
        Class<?> variableType = AbstractCompilerHandler.getVariableType(alphaNode);
        return AbstractCompilerHandler.getVariableName(variableType, alphaNode.getId());
    }

    protected String getContextVariableName(AlphaNode alphaNode) {
        Class<ContextEntry> variableType = ContextEntry.class;
        return AbstractCompilerHandler.getVariableName(variableType, alphaNode.getId());
    }

    protected static String getVariableName(Sink sink) {
        Class<?> variableType = AbstractCompilerHandler.getVariableType(sink);
        return AbstractCompilerHandler.getVariableName(variableType, sink.getId());
    }

    protected String getVariableName() {
        return MAP_VARIABLE_NAME_SUFFIX;
    }

    protected static String getVariableName(Class<?> clazz, int nodeId) {
        String type = clazz.getSimpleName();
        return Character.toLowerCase(type.charAt(0)) + type.substring(1) + nodeId;
    }

    protected String getAlphaNodeVariableName(AlphaNode alphaNode) {
        return AbstractCompilerHandler.getVariableName(AlphaNode.class, alphaNode.getId());
    }

    protected String getRangeIndexVariableName(AlphaRangeIndex alphaRangeIndex, int minId) {
        return RANGE_INDEX_VARIABLE_NAME_PREFIX + minId + "_" + alphaRangeIndex.getFieldIndex().getIndex();
    }

    protected int getMinIdFromRangeIndex(AlphaRangeIndex alphaRangeIndex) {
        return alphaRangeIndex.getAllValues().stream().map(BaseNode::getId).mapToInt(v -> v).min().orElseThrow(NoSuchElementException::new);
    }
}

