/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerConfigProvider;

public class KieServerConfigProviderLoader {
    private static final List<KieServerConfigProvider> PROVIDERS;
    private static final List<KieServerConfigItem> ITEMS;

    private KieServerConfigProviderLoader() {
    }

    public static List<KieServerConfigProvider> getConfigProviders() {
        return PROVIDERS;
    }

    public static List<KieServerConfigItem> getConfigItems() {
        return ITEMS;
    }

    static {
        ServiceLoader<KieServerConfigProvider> serviceLoader = ServiceLoader.load(KieServerConfigProvider.class);
        PROVIDERS = StreamSupport.stream(Spliterators.spliteratorUnknownSize(serviceLoader.iterator(), 256), false).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        ITEMS = PROVIDERS.stream().map(KieServerConfigProvider::getItems).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }
}

