/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.service;

import java.util.ServiceLoader;
import org.jbpm.document.service.DocumentStorageService;
import org.jbpm.document.service.impl.DocumentStorageServiceImpl;

public class DocumentStorageServiceProvider {
    private static final ServiceLoader<DocumentStorageService> storageServices = ServiceLoader.load(DocumentStorageService.class);
    private static DocumentStorageServiceProvider INSTANCE = new DocumentStorageServiceProvider();
    private DocumentStorageService documentStorageService;

    private DocumentStorageServiceProvider() {
        this.discover();
    }

    private synchronized void discover() {
        for (DocumentStorageService foundService : storageServices) {
            if (this.documentStorageService != null) {
                throw new RuntimeException("Ambiguous DocumentStorageService discovery, found more than one implementation");
            }
            this.documentStorageService = foundService;
        }
        if (this.documentStorageService == null) {
            this.documentStorageService = new DocumentStorageServiceImpl();
        }
    }

    public static DocumentStorageServiceProvider get() {
        return INSTANCE;
    }

    public DocumentStorageService getStorageService() {
        return DocumentStorageServiceProvider.INSTANCE.documentStorageService;
    }
}

