/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model.solver;

import java.util.Objects;
import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.core.model.TaskOrUser;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class StartAndEndTimeUpdatingVariableListener
implements VariableListener<Task> {
    public void beforeEntityAdded(ScoreDirector scoreDirector, Task task) {
    }

    public void afterEntityAdded(ScoreDirector scoreDirector, Task task) {
        StartAndEndTimeUpdatingVariableListener.updateStartAndEndTime(scoreDirector, task);
    }

    public void beforeVariableChanged(ScoreDirector scoreDirector, Task task) {
    }

    public void afterVariableChanged(ScoreDirector scoreDirector, Task task) {
        StartAndEndTimeUpdatingVariableListener.updateStartAndEndTime(scoreDirector, task);
    }

    public void beforeEntityRemoved(ScoreDirector scoreDirector, Task task) {
    }

    public void afterEntityRemoved(ScoreDirector scoreDirector, Task task) {
    }

    private static void updateStartAndEndTime(ScoreDirector scoreDirector, Task sourceTask) {
        Task shadowTask;
        Integer previousEndTime;
        TaskOrUser previous = sourceTask.getPreviousTaskOrUser();
        Integer startTime = previousEndTime = previous == null ? null : previous.getEndTimeInMinutes();
        Integer endTime = StartAndEndTimeUpdatingVariableListener.calculateEndTime(shadowTask, startTime);
        for (shadowTask = sourceTask; shadowTask != null && !Objects.equals(shadowTask.getStartTimeInMinutes(), startTime); shadowTask = shadowTask.getNextTask()) {
            scoreDirector.beforeVariableChanged((Object)shadowTask, "startTimeInMinutes");
            shadowTask.setStartTimeInMinutes(startTime);
            scoreDirector.afterVariableChanged((Object)shadowTask, "startTimeInMinutes");
            scoreDirector.beforeVariableChanged((Object)shadowTask, "endTimeInMinutes");
            shadowTask.setEndTime(endTime);
            scoreDirector.afterVariableChanged((Object)shadowTask, "endTimeInMinutes");
            previousEndTime = shadowTask.getEndTimeInMinutes();
            startTime = previousEndTime;
            endTime = StartAndEndTimeUpdatingVariableListener.calculateEndTime(shadowTask, startTime);
        }
    }

    private static Integer calculateEndTime(Task shadowTask, Integer startTime) {
        if (startTime == null || shadowTask == null) {
            return 0;
        }
        return startTime + shadowTask.getDurationInMinutes();
    }
}

