/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.server.services.taskassigning.user.system.api.UserSystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSystemServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserSystemServiceLoader.class);

    private UserSystemServiceLoader() {
    }

    public static Map<String, UserSystemService> loadServices(ClassLoader cl) {
        HashMap<String, UserSystemService> result = new HashMap<String, UserSystemService>();
        ServiceLoader<UserSystemService> availableServices = ServiceLoader.load(UserSystemService.class, cl);
        for (UserSystemService service : availableServices) {
            UserSystemService existed = result.putIfAbsent(service.getName(), service);
            if (existed == null) {
                LOGGER.debug("UserSystemService {} was added to the result", (Object)service.getName());
                continue;
            }
            LOGGER.warn("UserSystemService {} was already added to the result, this another instance will be discarded.", (Object)service);
        }
        return result;
    }
}

