/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.api.KieControllerNotDefinedException;
import org.kie.server.services.api.StartupStrategy;
import org.kie.server.services.impl.ContainerManager;
import org.kie.server.services.impl.DummyContainerManager;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.controller.ControllerConnectRunnable;
import org.kie.server.services.impl.storage.KieServerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableContainerStartupStrategy
implements StartupStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ImmutableContainerStartupStrategy.class);
    private Set<KieContainerResource> kieContainers;

    public ImmutableContainerStartupStrategy(List<KieContainerResource> kieContainer) {
        this.kieContainers = new HashSet<KieContainerResource>(kieContainer);
    }

    @Override
    public void startup(KieServerImpl kieServer, ContainerManager containerManager, KieServerState currentState, AtomicBoolean kieServerActive) {
        KieServerInfo kieServerInfo = kieServer.getInfoInternal();
        KieServerSetup kieServerSetup = new KieServerSetup();
        kieServerSetup.setContainers(this.kieContainers);
        kieServer.addServerStatusMessage(kieServerInfo);
        if (Boolean.parseBoolean(currentState.getConfiguration().getConfigItemValue("org.kie.server.sync.deploy", "false"))) {
            containerManager.installContainersSync(kieServer, this.kieContainers, currentState, kieServerSetup);
        } else {
            containerManager.installContainers(kieServer, this.kieContainers, currentState, kieServerSetup);
        }
        KieServerController kieController = kieServer.getController();
        try {
            kieController.connect(kieServerInfo);
        }
        catch (KieControllerNotDefinedException kieControllerNotDefinedException) {
        }
        catch (KieControllerNotConnectedException e) {
            logger.warn("Unable to connect to any controllers, delaying container installation until connection can be established");
            Thread connectToControllerThread = new Thread((Runnable)new ControllerConnectRunnable(kieServerActive, kieController, kieServerInfo, currentState, new DummyContainerManager(), kieServer, this), "KieServer-ControllerConnect");
            connectToControllerThread.start();
        }
    }

    public String toString() {
        return "InmutableContainerStartupStrategy - deploys once during startup the containers selected by the controller";
    }
}

