/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl.storage.memory;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;

public class InMemoryKieServerStateRepository
implements KieServerStateRepository {
    private Map<String, KieServerState> data = new ConcurrentHashMap<String, KieServerState>();

    @Override
    public void store(String serverId, KieServerState kieServerState) {
        this.data.put(serverId, kieServerState);
    }

    @Override
    public KieServerState load(String serverId) {
        if (!this.data.containsKey(serverId)) {
            KieServerState newState = new KieServerState();
            newState.setConfiguration(new KieServerConfig());
            newState.setContainers(new HashSet<KieContainerResource>());
            this.data.put(serverId, newState);
        }
        return this.data.get(serverId);
    }
}

