/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.simplebigdecimal;

import java.math.BigDecimal;
import org.optaplanner.core.api.score.buildin.simplebigdecimal.SimpleBigDecimalScore;
import org.optaplanner.core.impl.score.inliner.BigDecimalWeightedScoreImpacter;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;

public class SimpleBigDecimalScoreInliner
extends ScoreInliner<SimpleBigDecimalScore> {
    protected BigDecimal score = BigDecimal.ZERO;

    protected SimpleBigDecimalScoreInliner(boolean constraintMatchEnabled) {
        super(constraintMatchEnabled);
    }

    public BigDecimalWeightedScoreImpacter buildWeightedScoreImpacter(SimpleBigDecimalScore constraintWeight) {
        if (constraintWeight.equals(SimpleBigDecimalScore.ZERO)) {
            throw new IllegalArgumentException("The constraintWeight (" + constraintWeight + ") cannot be zero, this constraint should have been culled during node creation.");
        }
        BigDecimal simpleConstraintWeight = constraintWeight.getScore();
        return (matchWeight, matchScoreConsumer) -> {
            BigDecimal impact = simpleConstraintWeight.multiply(matchWeight);
            this.score = this.score.add(impact);
            if (this.constraintMatchEnabled) {
                matchScoreConsumer.accept(SimpleBigDecimalScore.of(impact));
            }
            return () -> {
                this.score = this.score.subtract(impact);
            };
        };
    }

    @Override
    public SimpleBigDecimalScore extractScore(int initScore) {
        return SimpleBigDecimalScore.ofUninitialized(initScore, this.score);
    }

    public String toString() {
        return SimpleBigDecimalScore.class.getSimpleName() + " inliner";
    }
}

