/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.assignment.impl;

import org.jbpm.services.task.assignment.AssignmentService;
import org.jbpm.services.task.assignment.AssignmentServiceRegistry;
import org.kie.api.task.TaskContext;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelFactory;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.assignment.Assignment;
import org.kie.internal.task.api.assignment.AssignmentStrategy;
import org.kie.internal.task.api.model.InternalTaskData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentServiceImpl
implements AssignmentService {
    private static final Logger logger = LoggerFactory.getLogger(AssignmentServiceImpl.class);
    private static final String ENABLED_PROPERTY = "org.jbpm.task.assignment.enabled";
    private static final String TASK_IMPLICIT_INPUT_VAR_ASSIGNMENT = "AssignmentStrategy";
    private boolean enabled = Boolean.parseBoolean(System.getProperty("org.jbpm.task.assignment.enabled", "false"));
    private AssignmentStrategy strategy;
    private AssignmentServiceRegistry registry = AssignmentServiceRegistry.get();
    private TaskModelFactory taskModelFactory = TaskModelProvider.getFactory();

    public AssignmentServiceImpl() {
        this.strategy = this.registry.getStrategy(System.getProperty("org.jbpm.task.assignment.strategy", "PotentialOwnerBusyness"));
    }

    public AssignmentServiceImpl(AssignmentStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void assignTask(Task task, TaskContext context) {
        this.assignTask(task, context, null);
    }

    @Override
    public void assignTask(Task task, TaskContext context, String excludedUser) {
        if (!this.isEnabled()) {
            logger.debug("AssignmentService is not enabled - to enable it set system property 'org.jbpm.task.assignment.enabled' to true");
            return;
        }
        AssignmentStrategy computedStrategy = this.computeAssignmentStrategyForTask(task);
        Assignment assignTo = computedStrategy.apply(task, context, excludedUser);
        if (assignTo == null || assignTo.getUser() == null) {
            logger.warn("Strategy {} did not return any assignment for task {}", (Object)computedStrategy.getIdentifier(), (Object)task);
            return;
        }
        logger.debug("Actual owner returned by strategy {} is {} for task {}", new Object[]{computedStrategy.getIdentifier(), assignTo, task});
        User actualOwner = this.taskModelFactory.newUser(assignTo.getUser());
        ((InternalTaskData)task.getTaskData()).setActualOwner(actualOwner);
        ((InternalTaskData)task.getTaskData()).setStatus(Status.Reserved);
    }

    @Override
    public void onTaskDone(Task task, TaskContext context) {
        if (!this.isEnabled()) {
            logger.debug("AssignmentService is not enabled - to enable it set system property 'org.jbpm.task.assignment.enabled' to true");
            return;
        }
        this.computeAssignmentStrategyForTask(task).taskDone(task, context);
        logger.debug("Assignment strategy notified about task {} being done", (Object)task);
    }

    private AssignmentStrategy computeAssignmentStrategyForTask(Task task) {
        if (task.getTaskData().getTaskInputVariables() != null && task.getTaskData().getTaskInputVariables().containsKey(TASK_IMPLICIT_INPUT_VAR_ASSIGNMENT)) {
            String userTaskStrategy = (String)task.getTaskData().getTaskInputVariables().get(TASK_IMPLICIT_INPUT_VAR_ASSIGNMENT);
            return userTaskStrategy != null ? this.registry.getStrategy(userTaskStrategy) : new AssignmentStrategy(){

                public String getIdentifier() {
                    return "NoAssignmentStrategy";
                }

                public Assignment apply(Task task, TaskContext context, String excludedUser) {
                    return null;
                }
            };
        }
        return this.strategy;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

