/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.IntervalTrigger;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.services.task.commands.ExecuteDeadlinesCommand;
import org.jbpm.services.task.commands.InitDeadlinesCommand;
import org.jbpm.services.task.deadlines.NotificationListener;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.command.Command;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.DeadlineSummary;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.InternalTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDeadlinesServiceImpl
implements TaskDeadlinesService {
    private static final Logger logger = LoggerFactory.getLogger(TaskDeadlinesServiceImpl.class);
    protected static volatile CommandExecutor instance;
    protected static NotificationListener notificationListener;
    private static volatile ScheduledThreadPoolExecutor scheduler;
    private static volatile Map<Long, List<ScheduledFuture<ScheduledTaskDeadline>>> startScheduledTaskDeadlines;
    private static volatile Map<Long, List<ScheduledFuture<ScheduledTaskDeadline>>> endScheduledTaskDeadlines;
    private static volatile Map<String, JobHandle> jobHandles;
    private TaskPersistenceContext persistenceContext;

    public TaskDeadlinesServiceImpl() {
    }

    public TaskDeadlinesServiceImpl(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void setPersistenceContext(TaskPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public void schedule(long taskId, long deadlineId, long delay, TaskDeadlinesService.DeadlineType type) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        String deploymentId = task.getTaskData().getDeploymentId();
        TimerService timerService = TimerServiceRegistry.getInstance().get(deploymentId + "-timerServiceId");
        if (timerService != null && timerService instanceof GlobalTimerService) {
            TaskDeadlineJob deadlineJob = new TaskDeadlineJob(taskId, deadlineId, type, deploymentId, task.getTaskData().getProcessInstanceId());
            IntervalTrigger trigger = new IntervalTrigger(timerService.getCurrentTime(), null, null, -1, delay, 0L, null, null);
            JobHandle handle = timerService.scheduleJob((Job)deadlineJob, (JobContext)new TaskDeadlineJobContext(deadlineJob.getId(), task.getTaskData().getProcessInstanceId(), deploymentId), (Trigger)trigger);
            logger.debug("scheduling timer job for deadline {} and task {}  using timer service {}", new Object[]{deadlineJob.getId(), taskId, timerService});
            jobHandles.put(deadlineJob.getId(), handle);
        } else {
            ScheduledFuture<ScheduledTaskDeadline> scheduled = scheduler.schedule(new ScheduledTaskDeadline(taskId, deadlineId, type, deploymentId, task.getTaskData().getProcessInstanceId()), delay, TimeUnit.MILLISECONDS);
            List<ScheduledFuture<ScheduledTaskDeadline>> knownFutures = null;
            if (type == TaskDeadlinesService.DeadlineType.START) {
                knownFutures = startScheduledTaskDeadlines.get(taskId);
            } else if (type == TaskDeadlinesService.DeadlineType.END) {
                knownFutures = endScheduledTaskDeadlines.get(taskId);
            }
            if (knownFutures == null) {
                knownFutures = new CopyOnWriteArrayList<ScheduledFuture<ScheduledTaskDeadline>>();
            }
            knownFutures.add(scheduled);
            if (type == TaskDeadlinesService.DeadlineType.START) {
                startScheduledTaskDeadlines.put(taskId, knownFutures);
            } else if (type == TaskDeadlinesService.DeadlineType.END) {
                endScheduledTaskDeadlines.put(taskId, knownFutures);
            }
        }
    }

    public void unschedule(long taskId, TaskDeadlinesService.DeadlineType type) {
        block15: {
            block13: {
                TimerService timerService;
                Deadlines deadlines;
                String deploymentId;
                Task task;
                block14: {
                    task = this.persistenceContext.findTask(Long.valueOf(taskId));
                    deploymentId = task.getTaskData().getDeploymentId();
                    deadlines = ((InternalTask)task).getDeadlines();
                    timerService = TimerServiceRegistry.getInstance().get(deploymentId + "-timerServiceId");
                    if (timerService == null || !(timerService instanceof GlobalTimerService)) break block13;
                    if (type != TaskDeadlinesService.DeadlineType.START) break block14;
                    List startDeadlines = deadlines.getStartDeadlines();
                    List resultList = (List)this.persistenceContext.queryWithParametersInTransaction("UnescalatedStartDeadlinesByTaskId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskId", taskId}), ClassUtil.castClass(List.class));
                    for (DeadlineSummary summary : resultList) {
                        TaskDeadlineJob deadlineJob = new TaskDeadlineJob(summary.getTaskId(), summary.getDeadlineId(), TaskDeadlinesService.DeadlineType.START, deploymentId, task.getTaskData().getProcessInstanceId());
                        logger.debug("unscheduling timer job for deadline {} {} and task {}  using timer service {}", new Object[]{deadlineJob.getId(), summary.getDeadlineId(), taskId, timerService});
                        JobHandle jobHandle = jobHandles.remove(deadlineJob.getId());
                        if (jobHandle == null) {
                            jobHandle = ((GlobalTimerService)timerService).buildJobHandleForContext((NamedJobContext)new TaskDeadlineJobContext(deadlineJob.getId(), task.getTaskData().getProcessInstanceId(), deploymentId));
                        }
                        timerService.removeJob(jobHandle);
                        for (Deadline deadline : startDeadlines) {
                            if (deadline.getId() != summary.getDeadlineId()) continue;
                            deadline.setEscalated(Boolean.valueOf(true));
                        }
                    }
                    break block15;
                }
                if (type != TaskDeadlinesService.DeadlineType.END) break block15;
                List endDeadlines = deadlines.getStartDeadlines();
                List resultList = (List)this.persistenceContext.queryWithParametersInTransaction("UnescalatedEndDeadlinesByTaskId", (Map)this.persistenceContext.addParametersToMap(new Object[]{"taskId", taskId}), ClassUtil.castClass(List.class));
                for (DeadlineSummary summary : resultList) {
                    TaskDeadlineJob deadlineJob = new TaskDeadlineJob(summary.getTaskId(), summary.getDeadlineId(), TaskDeadlinesService.DeadlineType.END, deploymentId, task.getTaskData().getProcessInstanceId());
                    logger.debug("unscheduling timer job for deadline {} and task {}  using timer service {}", new Object[]{deadlineJob.getId(), taskId, timerService});
                    JobHandle jobHandle = jobHandles.remove(deadlineJob.getId());
                    if (jobHandle == null) {
                        jobHandle = ((GlobalTimerService)timerService).buildJobHandleForContext((NamedJobContext)new TaskDeadlineJobContext(deadlineJob.getId(), task.getTaskData().getProcessInstanceId(), deploymentId));
                    }
                    timerService.removeJob(jobHandle);
                    for (Deadline deadline : endDeadlines) {
                        if (deadline.getId() != summary.getDeadlineId()) continue;
                        deadline.setEscalated(Boolean.valueOf(true));
                    }
                }
                break block15;
            }
            List<ScheduledFuture<ScheduledTaskDeadline>> knownFutures = null;
            if (type == TaskDeadlinesService.DeadlineType.START) {
                knownFutures = startScheduledTaskDeadlines.get(taskId);
            } else if (type == TaskDeadlinesService.DeadlineType.END) {
                knownFutures = endScheduledTaskDeadlines.get(taskId);
            }
            if (knownFutures == null) {
                return;
            }
            for (ScheduledFuture<ScheduledTaskDeadline> scheduled : knownFutures) {
                try {
                    if (scheduled.isDone() || scheduled.isCancelled()) continue;
                    scheduled.cancel(true);
                }
                catch (Exception e) {
                    logger.error("Error while cancelling scheduled deadline task for Task with id {} -> {}", (Object)taskId, (Object)e);
                }
            }
        }
    }

    public void unschedule(long taskId, Deadline deadline, TaskDeadlinesService.DeadlineType type) {
        Task task = this.persistenceContext.findTask(Long.valueOf(taskId));
        String deploymentId = task.getTaskData().getDeploymentId();
        Deadlines deadlines = ((InternalTask)task).getDeadlines();
        TimerService timerService = TimerServiceRegistry.getInstance().get(deploymentId + "-timerServiceId");
        if (timerService != null && timerService instanceof GlobalTimerService) {
            TaskDeadlineJob deadlineJob = new TaskDeadlineJob(taskId, deadline.getId(), type, deploymentId, task.getTaskData().getProcessInstanceId());
            logger.debug("unscheduling timer job for deadline {} {} and task {}  using timer service {}", new Object[]{deadlineJob.getId(), deadline.getId(), taskId, timerService});
            JobHandle jobHandle = jobHandles.remove(deadlineJob.getId());
            if (jobHandle == null) {
                jobHandle = ((GlobalTimerService)timerService).buildJobHandleForContext((NamedJobContext)new TaskDeadlineJobContext(deadlineJob.getId(), task.getTaskData().getProcessInstanceId(), deploymentId));
            }
            timerService.removeJob(jobHandle);
            deadline.setEscalated(Boolean.valueOf(true));
        }
    }

    public static CommandExecutor getInstance() {
        return instance;
    }

    public static synchronized void initialize(CommandExecutor instance) {
        if (instance != null) {
            TaskDeadlinesServiceImpl.instance = instance;
            TaskDeadlinesServiceImpl.getInstance().execute((Command)new InitDeadlinesCommand());
        }
    }

    public static synchronized void reset() {
        TaskDeadlinesServiceImpl.dispose();
        scheduler = new ScheduledThreadPoolExecutor(3);
    }

    public static synchronized void dispose() {
        try {
            if (scheduler != null) {
                scheduler.shutdownNow();
            }
            startScheduledTaskDeadlines.clear();
            endScheduledTaskDeadlines.clear();
            jobHandles.clear();
            notificationListener = null;
            instance = null;
        }
        catch (Exception e) {
            logger.error("Error encountered when disposing TaskDeadlineService", (Throwable)e);
        }
    }

    static {
        scheduler = new ScheduledThreadPoolExecutor(3);
        startScheduledTaskDeadlines = new ConcurrentHashMap<Long, List<ScheduledFuture<ScheduledTaskDeadline>>>();
        endScheduledTaskDeadlines = new ConcurrentHashMap<Long, List<ScheduledFuture<ScheduledTaskDeadline>>>();
        jobHandles = new ConcurrentHashMap<String, JobHandle>();
    }

    private static class TaskDeadlineJobContext
    implements NamedJobContext {
        private static final long serialVersionUID = -6838102884655249845L;
        private JobHandle jobHandle;
        private String jobName;
        private Long processInstanceId;
        private String deploymentId;

        public TaskDeadlineJobContext(String jobName, Long processInstanceId, String deploymentId) {
            this.jobName = jobName;
            this.processInstanceId = processInstanceId;
            this.deploymentId = deploymentId;
        }

        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        public String getJobName() {
            return this.jobName;
        }

        public Long getProcessInstanceId() {
            return this.processInstanceId;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return null;
        }
    }

    private static class TaskDeadlineJob
    implements Job,
    Serializable {
        private static final long serialVersionUID = -2453658968872574615L;
        private long taskId;
        private long deadlineId;
        private TaskDeadlinesService.DeadlineType type;
        private String deploymentId;
        private Long processInstanceId;

        public TaskDeadlineJob(long taskId, long deadlineId, TaskDeadlinesService.DeadlineType type, String deploymentId, Long processInstanceId) {
            this.taskId = taskId;
            this.deadlineId = deadlineId;
            this.type = type;
            this.deploymentId = deploymentId;
            this.processInstanceId = processInstanceId;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public long getDeadlineId() {
            return this.deadlineId;
        }

        public TaskDeadlinesService.DeadlineType getType() {
            return this.type;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public long getProcessInstanceId() {
            return this.processInstanceId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(JobContext ctx) {
            RuntimeManager runtimeManager = null;
            RuntimeEngine engine = null;
            CommandExecutor executor = null;
            if (this.deploymentId != null && this.processInstanceId != null) {
                runtimeManager = RuntimeManagerRegistry.get().getManager(this.deploymentId);
                engine = runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)this.processInstanceId));
                executor = engine.getTaskService();
            } else {
                executor = TaskDeadlinesServiceImpl.getInstance();
            }
            try {
                executor.execute((Command)new ExecuteDeadlinesCommand(this.taskId, this.deadlineId, this.type));
                if (runtimeManager == null || engine == null) return;
            }
            catch (NullPointerException e) {
                try {
                    logger.error("TaskDeadlineService instance is not available, most likely was not properly initialized - Job did not run!");
                    if (runtimeManager == null || engine == null) return;
                }
                catch (Throwable throwable) {
                    if (runtimeManager == null || engine == null) throw throwable;
                    runtimeManager.disposeRuntimeEngine(engine);
                    throw throwable;
                }
                runtimeManager.disposeRuntimeEngine(engine);
                return;
            }
            runtimeManager.disposeRuntimeEngine(engine);
            return;
        }

        public String getId() {
            return this.taskId + "_" + this.deadlineId + "_" + this.type;
        }
    }

    public static class ScheduledTaskDeadline
    implements Callable<ScheduledTaskDeadline>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private long taskId;
        private long deadlineId;
        private TaskDeadlinesService.DeadlineType type;
        private String deploymentId;
        private Long processInstanceId;

        public ScheduledTaskDeadline(long taskId, long deadlineId, TaskDeadlinesService.DeadlineType type, String deploymentId, Long processInstanceId) {
            this.taskId = taskId;
            this.deadlineId = deadlineId;
            this.type = type;
            this.deploymentId = deploymentId;
            this.processInstanceId = processInstanceId;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public long getDeadlineId() {
            return this.deadlineId;
        }

        public TaskDeadlinesService.DeadlineType getType() {
            return this.type;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public long getProcessInstanceId() {
            return this.processInstanceId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ScheduledTaskDeadline call() throws Exception {
            RuntimeManager runtimeManager = null;
            RuntimeEngine engine = null;
            CommandExecutor executor = null;
            if (this.deploymentId != null && this.processInstanceId != null) {
                runtimeManager = RuntimeManagerRegistry.get().getManager(this.deploymentId);
                engine = runtimeManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)this.processInstanceId));
                executor = engine.getTaskService();
            } else {
                executor = TaskDeadlinesServiceImpl.getInstance();
            }
            try {
                executor.execute((Command)new ExecuteDeadlinesCommand(this.taskId, this.deadlineId, this.type));
                if (runtimeManager == null || engine == null) return null;
            }
            catch (NullPointerException e) {
                try {
                    logger.error("TaskDeadlineService instance is not available, most likely was not properly initialized - Job did not run!");
                    if (runtimeManager == null || engine == null) return null;
                }
                catch (Throwable throwable) {
                    if (runtimeManager == null || engine == null) throw throwable;
                    runtimeManager.disposeRuntimeEngine(engine);
                    throw throwable;
                }
                runtimeManager.disposeRuntimeEngine(engine);
                return null;
            }
            runtimeManager.disposeRuntimeEngine(engine);
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.deadlineId ^ this.deadlineId >>> 32);
            result = 31 * result + (int)(this.taskId ^ this.taskId >>> 32);
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ScheduledTaskDeadline)) {
                return false;
            }
            ScheduledTaskDeadline other = (ScheduledTaskDeadline)obj;
            if (this.deadlineId != other.deadlineId) {
                return false;
            }
            if (this.taskId != other.taskId) {
                return false;
            }
            return !(this.type == null ? other.getType() != null : this.type.equals((Object)other.getType()));
        }
    }
}

