/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common.handlers;

import java.util.function.Consumer;
import javax.websocket.MessageHandler;
import org.kie.server.controller.api.model.notification.KieServerControllerNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerControllerNotificationMessageHandler
implements MessageHandler.Whole<KieServerControllerNotification> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerControllerNotificationMessageHandler.class);
    private Consumer<KieServerControllerNotification> notificationConsumer;

    public KieServerControllerNotificationMessageHandler(Consumer<KieServerControllerNotification> notificationConsumer) {
        this.notificationConsumer = notificationConsumer;
    }

    public void onMessage(KieServerControllerNotification message) {
        LOGGER.debug("Kie Server Controller Notification Message received: {}", (Object)message);
        if (this.notificationConsumer != null) {
            this.notificationConsumer.accept(message);
        }
    }
}

