/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Date;
import java.util.List;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.TupleSets;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.impl.MarshallingHelper;
import org.drools.core.marshalling.impl.TupleKey;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.TupleList;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.conf.TimedRuleExecutionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhreakTimerNode {
    private static final Logger log = LoggerFactory.getLogger(PhreakTimerNode.class);

    public void doNode(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, SegmentMemory smem, LeftTupleSink sink, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(timerNode, tm, pmem, sink, agenda, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(timerNode, tm, pmem, smem, sink, agenda, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(timerNode, tm, pmem, smem, sink, agenda, srcLeftTuples, trgLeftTuples);
        }
        PhreakTimerNode.doPropagateChildLeftTuples(tm, sink, trgLeftTuples, stagedLeftTuples);
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, SegmentMemory smem, LeftTupleSink sink, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples) {
        Timer timer = timerNode.getTimer();
        TimerService timerService = agenda.getWorkingMemory().getTimerService();
        long timestamp = timerService.getCurrentTime();
        String[] calendarNames = timerNode.getCalendarNames();
        Calendars calendars = agenda.getWorkingMemory().getCalendars();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            this.scheduleLeftTuple(timerNode, tm, pmem, smem, sink, agenda, timer, timerService, timestamp, calendarNames, calendars, leftTuple, trgLeftTuples, null);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, SegmentMemory smem, LeftTupleSink sink, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        Timer timer = timerNode.getTimer();
        TimerService timerService = agenda.getWorkingMemory().getTimerService();
        long timestamp = timerService.getCurrentTime();
        String[] calendarNames = timerNode.getCalendarNames();
        Calendars calendars = agenda.getWorkingMemory().getCalendars();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getStagedNext();
            DefaultJobHandle jobHandle = (DefaultJobHandle)leftTuple.getContextObject();
            if (jobHandle != null) {
                timerService.removeJob(jobHandle);
            }
            this.scheduleLeftTuple(timerNode, tm, pmem, smem, sink, agenda, timer, timerService, timestamp, calendarNames, calendars, leftTuple, trgLeftTuples, stagedLeftTuples);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, LeftTupleSink sink, InternalAgenda agenda, TupleSets<LeftTuple> srcLeftTuples, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        LeftTuple next;
        LeftTuple leftTuple;
        TimerService timerService = agenda.getWorkingMemory().getTimerService();
        TupleList leftTuples = tm.getInsertOrUpdateLeftTuples();
        TupleList deletes = tm.getDeleteLeftTuples();
        if (!deletes.isEmpty()) {
            leftTuple = (LeftTuple)deletes.getFirst();
            while (leftTuple != null) {
                next = (LeftTuple)leftTuple.getNext();
                srcLeftTuples.addDelete(leftTuple);
                if (log.isTraceEnabled()) {
                    log.trace("Timer Add Postponed Delete {}", (Object)leftTuple);
                }
                leftTuple.clear();
                leftTuple = next;
            }
            deletes.clear();
        }
        leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple childLeftTuple;
            next = (LeftTuple)leftTuple.getStagedNext();
            PropagationContext pctx = leftTuple.findMostRecentPropagationContext();
            Object obj = leftTuple.getContextObject();
            if (obj instanceof DefaultJobHandle) {
                timerService.removeJob((DefaultJobHandle)obj);
            } else if (obj instanceof TupleKey && pctx.getReaderContext() != null) {
                pctx.getReaderContext().removeTimerNodeScheduler(timerNode.getId(), (TupleKey)obj);
            }
            if (leftTuple.getMemory() != null) {
                leftTuples.remove(leftTuple);
                if (pctx.getFactHandle().isExpired()) {
                    PhreakTimerNode.doPropagateChildLeftTuple(sink, trgLeftTuples, stagedLeftTuples, leftTuple);
                    tm.getDeleteLeftTuples().add(leftTuple);
                    pmem.doLinkRule(agenda);
                    if (log.isTraceEnabled()) {
                        log.trace("Timer Postponed Delete {}", (Object)leftTuple);
                    }
                }
            }
            if (leftTuple.getMemory() == null && (childLeftTuple = leftTuple.getFirstChild()) != null) {
                childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                RuleNetworkEvaluator.deleteChildLeftTuple(childLeftTuple, trgLeftTuples, stagedLeftTuples);
                if (log.isTraceEnabled()) {
                    log.trace("Timer Delete {}", (Object)leftTuple);
                }
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    private void scheduleLeftTuple(final TimerNode timerNode, final TimerNode.TimerNodeMemory tm, final PathMemory pmem, final SegmentMemory smem, final LeftTupleSink sink, final InternalAgenda agenda, final Timer timer, final TimerService timerService, final long timestamp, final String[] calendarNames, final Calendars calendars, final LeftTuple leftTuple, final TupleSets<LeftTuple> trgLeftTuples, final TupleSets<LeftTuple> stagedLeftTuples) {
        final InternalWorkingMemory wm = agenda.getWorkingMemory();
        if (leftTuple.getPropagationContext().getReaderContext() == null) {
            Trigger trigger = this.createTrigger(timerNode, wm, timer, timestamp, calendarNames, calendars, leftTuple);
            this.scheduleTimer(timerNode, tm, smem, sink, wm, timerService, timestamp, leftTuple, trgLeftTuples, stagedLeftTuples, trigger);
        } else {
            Scheduler scheduler = new Scheduler(){

                @Override
                public void schedule(Trigger t) {
                    PhreakTimerNode.this.scheduleTimer(timerNode, tm, smem, sink, wm, timerService, timestamp, leftTuple, trgLeftTuples, stagedLeftTuples, t);
                    PhreakTimerNode.evaluate(pmem, agenda, sink, tm, trgLeftTuples);
                }

                @Override
                public Trigger getTrigger() {
                    return PhreakTimerNode.this.createTrigger(timerNode, wm, timer, timestamp, calendarNames, calendars, leftTuple);
                }
            };
            TupleKey key = MarshallingHelper.createTupleKey(leftTuple);
            leftTuple.getPropagationContext().getReaderContext().addTimerNodeScheduler(timerNode.getId(), key, scheduler);
            leftTuple.setContextObject(key);
        }
    }

    private Trigger createTrigger(TimerNode timerNode, InternalWorkingMemory wm, Timer timer, long timestamp, String[] calendarNames, Calendars calendars, LeftTuple leftTuple) {
        Object obj = leftTuple.getContextObject();
        DefaultJobHandle jobHandle = obj instanceof DefaultJobHandle ? (DefaultJobHandle)obj : null;
        return timer.createTrigger(timestamp, leftTuple, jobHandle, calendarNames, calendars, timerNode.getDeclarations(), wm);
    }

    private void scheduleTimer(TimerNode timerNode, TimerNode.TimerNodeMemory tm, SegmentMemory smem, LeftTupleSink sink, InternalWorkingMemory wm, TimerService timerService, long timestamp, LeftTuple leftTuple, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, Trigger trigger) {
        if (trigger.hasNextFireTime() == null) {
            return;
        }
        if (trigger.hasNextFireTime().getTime() <= timestamp) {
            LeftTuple childLeftTuple;
            if (log.isTraceEnabled()) {
                log.trace("Timer Fire Now {}", (Object)leftTuple);
            }
            if ((childLeftTuple = PhreakTimerNode.doPropagateChildLeftTuple(sink, trgLeftTuples, stagedLeftTuples, leftTuple)).getStagedType() != 0) {
                childLeftTuple.setContextObject(Boolean.TRUE);
            }
            trigger.nextFireTime();
            Date nextFireTime = trigger.hasNextFireTime();
            if (nextFireTime != null && nextFireTime.getTime() <= timestamp) {
                throw new IllegalStateException("Trigger.nextFireTime is not increasing");
            }
        }
        if (trigger.hasNextFireTime() != null) {
            TimerNodeJob job = new TimerNodeJob();
            TimerNodeJobContext jobCtx = new TimerNodeJobContext(timerNode.getId(), trigger, leftTuple, tm, sink, smem.getPathMemories(), wm);
            DefaultJobHandle jobHandle = (DefaultJobHandle)timerService.scheduleJob(job, jobCtx, trigger);
            leftTuple.setContextObject(jobHandle);
            if (log.isTraceEnabled()) {
                log.trace("Timer Scheduled {}", (Object)leftTuple);
            }
        }
    }

    private static void doPropagateChildLeftTuples(TimerNode.TimerNodeMemory tm, LeftTupleSink sink, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples) {
        TupleList leftTuples = tm.getInsertOrUpdateLeftTuples();
        LeftTuple leftTuple = (LeftTuple)leftTuples.getFirst();
        while (leftTuple != null) {
            LeftTuple next = (LeftTuple)leftTuple.getNext();
            PhreakTimerNode.doPropagateChildLeftTuple(sink, trgLeftTuples, stagedLeftTuples, leftTuple);
            leftTuple.clear();
            leftTuple = next;
        }
        if (tm.getDeleteLeftTuples().isEmpty()) {
            tm.setNodeCleanWithoutNotify();
        }
        leftTuples.clear();
    }

    private static LeftTuple doPropagateChildLeftTuple(LeftTupleSink sink, TupleSets<LeftTuple> trgLeftTuples, TupleSets<LeftTuple> stagedLeftTuples, LeftTuple leftTuple) {
        LeftTuple childLeftTuple = leftTuple.getFirstChild();
        if (childLeftTuple == null) {
            childLeftTuple = sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true);
            trgLeftTuples.addInsert(childLeftTuple);
            if (log.isTraceEnabled()) {
                log.trace("Timer Insert {}", (Object)childLeftTuple);
            }
        } else if (childLeftTuple.getContextObject() == Boolean.TRUE) {
            childLeftTuple.setContextObject(null);
        } else {
            RuleNetworkEvaluator.normalizeStagedTuples(stagedLeftTuples, childLeftTuple);
            trgLeftTuples.addUpdate(childLeftTuple);
            if (log.isTraceEnabled()) {
                log.trace("Timer Update {}", (Object)childLeftTuple);
            }
        }
        return childLeftTuple;
    }

    private static void evaluate(PathMemory pmem, InternalAgenda agenda, LeftTupleSink sink, TimerNode.TimerNodeMemory tm, TupleSets<LeftTuple> trgLeftTuples) {
        SegmentMemory[] smems = pmem.getSegmentMemories();
        SegmentMemory sm = tm.getSegmentMemory();
        int smemIndex = 0;
        for (SegmentMemory smem : smems) {
            if (smem == sm) break;
            ++smemIndex;
        }
        long bit = 1L;
        LeftTupleNode node = sm.getRootNode();
        while (node != sink) {
            bit <<= 1;
            node = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink();
        }
        RuleNetworkEvaluator.INSTANCE.outerEval(pmem, sink, bit, tm, smems, smemIndex, trgLeftTuples, agenda, new LinkedList<StackEntry>(), true, pmem.getRuleAgendaItem().getRuleExecutor());
    }

    public static class TimerNodeJobContext
    implements JobContext {
        private JobHandle jobHandle;
        private final Trigger trigger;
        private final Tuple tuple;
        private final int timerNodeId;
        private final TimerNode.TimerNodeMemory tm;
        private final LeftTupleSink sink;
        private final List<PathMemory> pmems;
        private final InternalWorkingMemory wm;

        public TimerNodeJobContext(int timerNodeId, Trigger trigger, Tuple tuple, TimerNode.TimerNodeMemory tm, LeftTupleSink sink, List<PathMemory> pmems, InternalWorkingMemory wm) {
            this.timerNodeId = timerNodeId;
            this.trigger = trigger;
            this.tuple = tuple;
            this.sink = sink;
            this.pmems = pmems;
            this.tm = tm;
            this.wm = wm;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public LeftTupleSink getSink() {
            return this.sink;
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public TimerNode.TimerNodeMemory getTimerNodeMemory() {
            return this.tm;
        }

        public List<PathMemory> getPathMemories() {
            return this.pmems;
        }

        @Override
        public InternalWorkingMemory getWorkingMemory() {
            return this.wm;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public int getTimerNodeId() {
            return this.timerNodeId;
        }
    }

    public static class TimerAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private final TimerNodeJobContext timerJobCtx;

        private TimerAction(TimerNodeJobContext timerJobCtx) {
            this.timerJobCtx = timerJobCtx;
        }

        @Override
        public boolean requiresImmediateFlushing() {
            return this.timerJobCtx.getWorkingMemory().getSessionConfiguration().getTimedRuleExecutionFilter() != null;
        }

        @Override
        public void execute(InternalWorkingMemory wm) {
            this.execute(wm, false);
        }

        public void execute(InternalWorkingMemory wm, boolean needEvaluation) {
            TupleList leftTuples = this.timerJobCtx.getTimerNodeMemory().getInsertOrUpdateLeftTuples();
            Tuple lt = this.timerJobCtx.getTuple();
            if (log.isTraceEnabled()) {
                log.trace("Timer Executor {} {}", (Object)this.timerJobCtx.getTrigger(), (Object)lt);
            }
            if (this.timerJobCtx.getJobHandle().isCancel()) {
                return;
            }
            if (lt.getMemory() == null) {
                leftTuples.add(lt);
            }
            this.timerJobCtx.getTimerNodeMemory().setNodeDirtyWithoutNotify();
            TimedRuleExecutionFilter filter = wm.getSessionConfiguration().getTimedRuleExecutionFilter();
            needEvaluation &= filter != null;
            for (PathMemory pmem : this.timerJobCtx.getPathMemories()) {
                if (pmem.getPathEndNode().getAssociatedRuleSize() == 0) continue;
                InternalAgenda agenda = pmem.getActualAgenda(wm);
                pmem.doLinkRule(agenda);
                if (!needEvaluation || !filter.accept(new Rule[]{pmem.getRule()})) continue;
                this.evaluateAndFireRule(pmem, agenda);
            }
        }

        private void evaluateAndFireRule(PathMemory pmem, InternalAgenda agenda) {
            RuleExecutor ruleExecutor = pmem.getRuleAgendaItem().getRuleExecutor();
            ruleExecutor.reEvaluateNetwork(agenda);
            ruleExecutor.fire(agenda);
        }
    }

    public static class TimerNodeJob
    implements Job {
        @Override
        public void execute(JobContext ctx) {
            TimerNodeJobContext timerJobCtx = (TimerNodeJobContext)ctx;
            InternalWorkingMemory wm = timerJobCtx.getWorkingMemory();
            wm.addPropagation(new TimerAction(timerJobCtx));
        }
    }

    public static interface Scheduler {
        public void schedule(Trigger var1);

        public Trigger getTrigger();
    }
}

