/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.optaplanner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.optaplanner.OptaplannerCommandServiceImpl;
import org.kie.server.services.optaplanner.SolverServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptaplannerKieServerExtension
implements KieServerExtension {
    private static final Logger logger = LoggerFactory.getLogger(OptaplannerKieServerExtension.class);
    public static final String EXTENSION_NAME = "OptaPlanner";
    private static final Boolean DROOLS_DISABLED = Boolean.parseBoolean(System.getProperty("org.drools.server.ext.disabled", "false"));
    private static final Boolean OPTAPLANNER_DISABLED = Boolean.parseBoolean(System.getProperty("org.optaplanner.server.ext.disabled", "false"));
    private KieServerRegistry registry;
    private SolverServiceBase solverServiceBase;
    private ExecutorService threadPool = null;
    private final List<Object> services = new ArrayList<Object>();
    private boolean initialized = false;
    private OptaplannerCommandServiceImpl optaplannerCommandService;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        return OPTAPLANNER_DISABLED == false && DROOLS_DISABLED == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        KieServerExtension droolsExtension = registry.getServerExtension("Drools");
        if (droolsExtension == null) {
            logger.warn("No Drools extension available, quiting...");
            return;
        }
        this.registry = registry;
        int availableProcessorCount = Runtime.getRuntime().availableProcessors();
        int resolvedActiveThreadCount = Math.max(1, availableProcessorCount - 2);
        int queueSize = Integer.parseInt(System.getProperty("org.optaplanner.server.ext.thread.pool.queue.size", String.valueOf(resolvedActiveThreadCount)));
        logger.info("Creating a ThreadPoolExecutor with corePoolSize = " + resolvedActiveThreadCount + ", maximumPoolSize = " + resolvedActiveThreadCount + ", queueSize = " + queueSize);
        this.threadPool = new ThreadPoolExecutor(resolvedActiveThreadCount, resolvedActiveThreadCount, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize));
        this.solverServiceBase = new SolverServiceBase(registry, this.threadPool);
        this.optaplannerCommandService = new OptaplannerCommandServiceImpl(registry, this.solverServiceBase);
        this.services.add(this.solverServiceBase);
        this.initialized = true;
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        this.solverServiceBase.disposeSolversForContainer(id, kieContainerInstance);
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] services = new Object[]{this.solverServiceBase, this.registry};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (serviceType.isAssignableFrom(this.optaplannerCommandService.getClass())) {
            return (T)this.optaplannerCommandService;
        }
        if (serviceType.isAssignableFrom(this.solverServiceBase.getClass())) {
            return (T)this.solverServiceBase;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "BRP";
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 25;
    }

    public String toString() {
        return "OptaPlanner KIE Server extension";
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        if (this.threadPool.isTerminated() && this.initialized) {
            messages.add(new Message(Severity.ERROR, this.getExtensionName() + " failed due to thread pool is terminated while the extension is still alive"));
        } else if (report) {
            messages.add(new Message(Severity.INFO, this.getExtensionName() + " is alive"));
        }
        return messages;
    }
}

