/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.jbpm.kafka;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jbpm.services.api.DeploymentEvent;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.MessageEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.SignalEvent;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.InternalRegisterableItemsFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.server.services.jbpm.kafka.KafkaEventProcessorFactory;
import org.kie.server.services.jbpm.kafka.KafkaServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaServerProducer
extends DefaultProcessEventListener {
    private static final Logger logger = LoggerFactory.getLogger(KafkaServerProducer.class);
    private Producer<String, byte[]> producer;
    private Supplier<Producer<String, byte[]>> producerSupplier;
    private KafkaEventProcessorFactory factory;
    private AtomicBoolean producerReady = new AtomicBoolean();

    public KafkaServerProducer(KafkaEventProcessorFactory factory, Supplier<Producer<String, byte[]>> producerSupplier) {
        this.factory = factory;
        this.producerSupplier = producerSupplier;
    }

    void close(Duration duration) {
        if (this.producerReady.compareAndSet(true, false)) {
            this.producer.close(duration);
        }
    }

    public void onMessage(MessageEvent event) {
        if (KafkaServerUtils.processMessages()) {
            this.sendEvent(event.getProcessInstance(), event.getMessageName(), event.getMessage());
        }
    }

    public void onSignal(SignalEvent event) {
        if (KafkaServerUtils.processSignals(event)) {
            this.sendEvent(event.getProcessInstance(), event.getSignalName(), event.getSignal());
        }
    }

    private void sendEvent(ProcessInstance processInstance, String name, Object value) {
        if (this.producerReady.compareAndSet(false, true)) {
            this.producer = this.producerSupplier.get();
        }
        try {
            String topic = KafkaServerUtils.topicFromSignal(name);
            this.producer.send(new ProducerRecord(topic, (Object)this.factory.getEventWriter(topic).writeEvent(processInstance, value)), (m, e) -> {
                if (e != null) {
                    this.logError(value, e);
                }
            });
        }
        catch (Exception e2) {
            this.logError(value, e2);
        }
    }

    private void logError(Object value, Exception e) {
        logger.error("Error publishing event {}", value, (Object)e);
    }

    public void activate(DeploymentEvent event) {
        ((InternalRegisterableItemsFactory)((InternalRuntimeManager)event.getDeployedUnit().getRuntimeManager()).getEnvironment().getRegisterableItemsFactory()).addProcessListener((ProcessEventListener)this);
    }

    public void deactivate(DeploymentEvent event) {
    }
}

