/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.scenariosimulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.Severity;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.scenariosimulation.ScenarioSimulationService;

public class ScenarioSimulationKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "Scenario Simulation";
    private static final Boolean SCESIM_DISABLED = Boolean.parseBoolean(System.getProperty("org.kie.scenariosimulation.server.ext.disabled", "true"));
    private static final Boolean DROOLS_DISABLED = Boolean.parseBoolean(System.getProperty("org.drools.server.ext.disabled", "false"));
    private static final Boolean DMN_DISABLED = Boolean.parseBoolean(System.getProperty("org.kie.dmn.server.ext.disabled", "false"));
    private KieServerRegistry context;
    private ScenarioSimulationService scenarioSimulationService;
    private boolean initialized = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isActive() {
        boolean scesimEnabled = SCESIM_DISABLED == false;
        boolean droolsEnabled = DROOLS_DISABLED == false;
        boolean dmnEnabled = DMN_DISABLED == false;
        boolean droolsOrDmnEnabled = droolsEnabled || dmnEnabled;
        return scesimEnabled && droolsOrDmnEnabled;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        this.context = registry;
        this.scenarioSimulationService = new ScenarioSimulationService(this.context);
        this.initialized = true;
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        ServiceLoader<KieServerApplicationComponentsService> appComponentsServices = ServiceLoader.load(KieServerApplicationComponentsService.class);
        ArrayList<Object> appComponentsList = new ArrayList<Object>();
        Object[] services = new Object[]{this.context, this.scenarioSimulationService};
        for (KieServerApplicationComponentsService appComponentsService : appComponentsServices) {
            appComponentsList.addAll(appComponentsService.getAppComponents(EXTENSION_NAME, type, services));
        }
        return appComponentsList;
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        return null;
    }

    public String getImplementedCapability() {
        return EXTENSION_NAME;
    }

    public List<Object> getServices() {
        return Collections.emptyList();
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return "Scenario Simulation KIE Server extension";
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        if (report) {
            messages.add(new Message(Severity.INFO, this.getExtensionName() + " is alive"));
        }
        return messages;
    }
}

