/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit;

import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.audit.jms.AsyncTaskLifeCycleEventProducer;

public class TaskAuditLoggerFactory {
    public static JPATaskLifeCycleEventListener newJPAInstance() {
        return new JPATaskLifeCycleEventListener(true);
    }

    public static JPATaskLifeCycleEventListener newJPAInstance(EntityManagerFactory emf) {
        return new JPATaskLifeCycleEventListener(emf);
    }

    public static AsyncTaskLifeCycleEventProducer newJMSInstance(Map<String, Object> properties) {
        Queue queue;
        ConnectionFactory connFactory;
        AsyncTaskLifeCycleEventProducer logger = new AsyncTaskLifeCycleEventProducer();
        boolean transacted = true;
        if (properties.containsKey("jbpm.audit.jms.transacted")) {
            Object transactedObj = properties.get("jbpm.audit.jms.transacted");
            transacted = transactedObj instanceof Boolean ? (Boolean)properties.get("jbpm.audit.jms.transacted") : Boolean.parseBoolean(transactedObj.toString());
        }
        logger.setTransacted(transacted);
        if (properties.containsKey("jbpm.audit.jms.connection.factory")) {
            connFactory = (ConnectionFactory)properties.get("jbpm.audit.jms.connection.factory");
            logger.setConnectionFactory(connFactory);
        }
        if (properties.containsKey("jbpm.audit.jms.queue")) {
            queue = (Queue)properties.get("jbpm.audit.jms.queue");
            logger.setQueue(queue);
        }
        try {
            if (properties.containsKey("jbpm.audit.jms.connection.factory.jndi")) {
                connFactory = (ConnectionFactory)InitialContext.doLookup((String)properties.get("jbpm.audit.jms.connection.factory.jndi"));
                logger.setConnectionFactory(connFactory);
            }
            if (properties.containsKey("jbpm.audit.jms.queue.jndi")) {
                queue = (Queue)InitialContext.doLookup((String)properties.get("jbpm.audit.jms.queue.jndi"));
                logger.setQueue(queue);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Error when looking up ConnectionFactory/Queue", e);
        }
        return logger;
    }

    public static AsyncTaskLifeCycleEventProducer newJMSInstance(boolean transacted, ConnectionFactory connFactory, Queue queue) {
        AsyncTaskLifeCycleEventProducer logger = new AsyncTaskLifeCycleEventProducer();
        logger.setTransacted(transacted);
        logger.setConnectionFactory(connFactory);
        logger.setQueue(queue);
        return logger;
    }
}

