/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.provider;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.TransformationDictionary;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.util.StringUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.kie.dependencies.HasKnowledgeBuilder;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDataDictionaryASTFactory;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDerivedFieldASTFactory;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrFactory;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModelWithSources;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DroolsModelProvider<T extends Model, E extends KiePMMLDroolsModel>
implements ModelImplementationProvider<T, E> {
    private static final Logger logger = LoggerFactory.getLogger((String)DroolsModelProvider.class.getName());

    public E getKiePMMLModel(String packageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, T model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModel {} {} {} {}", new Object[]{packageName, dataDictionary, transformationDictionary, model});
        if (!(hasClassloader instanceof HasKnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting HasKnowledgeBuilder, received %s", hasClassloader.getClass().getName()));
        }
        HasKnowledgeBuilder hasKnowledgeBuilder = (HasKnowledgeBuilder)hasClassloader;
        KnowledgeBuilderImpl knowledgeBuilder = (KnowledgeBuilderImpl)hasKnowledgeBuilder.getKnowledgeBuilder();
        HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
        KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(dataDictionary, transformationDictionary, model, fieldTypeMap);
        E toReturn = this.getKiePMMLDroolsModel(dataDictionary, transformationDictionary, model, fieldTypeMap, packageName, hasClassloader);
        PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, ((KiePMMLDroolsModel)((Object)toReturn)).getKModulePackageName());
        CompositePackageDescr compositePackageDescr = new CompositePackageDescr(null, packageDescr);
        knowledgeBuilder.buildPackages(Collections.singletonList(compositePackageDescr));
        return toReturn;
    }

    public E getKiePMMLModelWithSources(String packageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, T model, HasClassLoader hasClassloader) {
        logger.trace("getKiePMMLModelWithSources {} {} {}", new Object[]{dataDictionary, model, hasClassloader});
        if (!(hasClassloader instanceof HasKnowledgeBuilder)) {
            throw new KiePMMLException(String.format("Expecting HasKnowledgeBuilder, received %s", hasClassloader.getClass().getName()));
        }
        try {
            HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
            KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(dataDictionary, transformationDictionary, model, fieldTypeMap);
            Map<String, String> sourcesMap = this.getKiePMMLDroolsModelSourcesMap(dataDictionary, transformationDictionary, model, fieldTypeMap, packageName);
            PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, packageName);
            HasKnowledgeBuilder hasKnowledgeBuilder = (HasKnowledgeBuilder)hasClassloader;
            KnowledgeBuilderImpl knowledgeBuilder = (KnowledgeBuilderImpl)hasKnowledgeBuilder.getKnowledgeBuilder();
            String pkgUUID = StringUtils.getPkgUUID((ReleaseId)knowledgeBuilder.getReleaseId(), (String)packageName);
            packageDescr.setPreferredPkgUUID(pkgUUID);
            KiePMMLDroolsModelWithSources toReturn = new KiePMMLDroolsModelWithSources(model.getModelName(), packageName, sourcesMap, packageDescr);
            knowledgeBuilder.registerPackage(packageDescr);
            return (E)((Object)toReturn);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public PackageDescr getPackageDescr(KiePMMLDroolsAST kiePMMLDroolsAST, String packageName) {
        return KiePMMLDescrFactory.getBaseDescr(kiePMMLDroolsAST, packageName);
    }

    public abstract E getKiePMMLDroolsModel(DataDictionary var1, TransformationDictionary var2, T var3, Map<String, KiePMMLOriginalTypeGeneratedType> var4, String var5, HasClassLoader var6);

    public abstract KiePMMLDroolsAST getKiePMMLDroolsAST(DataDictionary var1, T var2, Map<String, KiePMMLOriginalTypeGeneratedType> var3, List<KiePMMLDroolsType> var4);

    public abstract Map<String, String> getKiePMMLDroolsModelSourcesMap(DataDictionary var1, TransformationDictionary var2, T var3, Map<String, KiePMMLOriginalTypeGeneratedType> var4, String var5) throws IOException;

    protected KiePMMLDroolsAST getKiePMMLDroolsASTCommon(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, T model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        this.addTransformationsDerivedFields(fieldTypeMap, transformationDictionary, model.getLocalTransformations());
        List<KiePMMLDroolsType> types = fieldTypeMap.values().stream().map(kiePMMLOriginalTypeGeneratedType -> {
            String type = DATA_TYPE.byName((String)kiePMMLOriginalTypeGeneratedType.getOriginalType()).getMappedClass().getSimpleName();
            return new KiePMMLDroolsType(kiePMMLOriginalTypeGeneratedType.getGeneratedType(), type);
        }).collect(Collectors.toList());
        types.addAll(KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(dataDictionary));
        return this.getKiePMMLDroolsAST(dataDictionary, model, fieldTypeMap, types);
    }

    protected void addTransformationsDerivedFields(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, TransformationDictionary transformationDictionary, LocalTransformations localTransformations) {
        KiePMMLDerivedFieldASTFactory kiePMMLDerivedFieldASTFactory = KiePMMLDerivedFieldASTFactory.factory(fieldTypeMap);
        if (transformationDictionary != null && transformationDictionary.getDerivedFields() != null) {
            kiePMMLDerivedFieldASTFactory.declareTypes(transformationDictionary.getDerivedFields());
        }
        if (localTransformations != null && localTransformations.getDerivedFields() != null) {
            kiePMMLDerivedFieldASTFactory.declareTypes(localTransformations.getDerivedFields());
        }
    }
}

