/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.solver;

import java.util.Comparator;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;

public class DepotDistanceCustomerDifficultyWeightFactory
implements SelectionSorterWeightFactory<VehicleRoutingSolution, Customer> {
    public DepotDistanceCustomerDifficultyWeight createSorterWeight(VehicleRoutingSolution vehicleRoutingSolution, Customer customer) {
        Depot depot = vehicleRoutingSolution.getDepotList().get(0);
        return new DepotDistanceCustomerDifficultyWeight(customer, customer.getLocation().getDistanceTo(depot.getLocation()) + depot.getLocation().getDistanceTo(customer.getLocation()));
    }

    public static class DepotDistanceCustomerDifficultyWeight
    implements Comparable<DepotDistanceCustomerDifficultyWeight> {
        private static final Comparator<DepotDistanceCustomerDifficultyWeight> COMPARATOR = Comparator.comparingLong(weight -> weight.depotRoundTripDistance).thenComparingInt(weight -> weight.customer.getDemand()).thenComparingDouble(weight -> weight.customer.getLocation().getLatitude()).thenComparingDouble(weight -> weight.customer.getLocation().getLongitude()).thenComparing(weight -> weight.customer, Comparator.comparingLong(AbstractPersistable::getId));
        private final Customer customer;
        private final long depotRoundTripDistance;

        public DepotDistanceCustomerDifficultyWeight(Customer customer, long depotRoundTripDistance) {
            this.customer = customer;
            this.depotRoundTripDistance = depotRoundTripDistance;
        }

        @Override
        public int compareTo(DepotDistanceCustomerDifficultyWeight other) {
            return COMPARATOR.compare(this, other);
        }
    }
}

