/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.Model;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.jpmml.model.PMMLUtil;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.xml.sax.SAXException;

public class KiePMMLUtil {
    public static final String SEGMENTID_TEMPLATE = "%sSegment%s";
    static final String MODELNAME_TEMPLATE = "%s%s%s";
    static final String SEGMENTMODELNAME_TEMPLATE = "Segment%s%s";

    private KiePMMLUtil() {
    }

    public static PMML load(String source) throws SAXException, JAXBException {
        return KiePMMLUtil.load(new ByteArrayInputStream(source.getBytes()), "");
    }

    public static PMML load(InputStream is, String fileName) throws SAXException, JAXBException {
        PMML toReturn = PMMLUtil.unmarshal((InputStream)is);
        String cleanedFileName = fileName.contains(".") ? fileName.substring(0, fileName.indexOf(46)) : fileName;
        KiePMMLUtil.populateMissingNames(toReturn, cleanedFileName);
        List dataFields = toReturn.getDataDictionary().getDataFields();
        for (Model model : toReturn.getModels()) {
            if (model.getOutput() == null || model.getOutput().getOutputFields() == null) continue;
            KiePMMLUtil.populateMissingOutputFieldDataType(model.getOutput().getOutputFields(), model.getMiningSchema().getMiningFields(), dataFields);
        }
        return toReturn;
    }

    static void populateMissingNames(PMML toPopulate, String fileName) {
        List models = toPopulate.getModels();
        for (int i = 0; i < models.size(); ++i) {
            Model model = (Model)models.get(i);
            if (model.getModelName() == null || model.getModelName().isEmpty()) {
                String modelName = String.format(MODELNAME_TEMPLATE, fileName, model.getClass().getSimpleName(), i);
                model.setModelName(modelName);
            }
            if (!(model instanceof MiningModel)) continue;
            KiePMMLUtil.populateCorrectMiningModel((MiningModel)model);
        }
    }

    static void populateCorrectMiningModel(MiningModel miningModel) {
        List segments = miningModel.getSegmentation().getSegments();
        for (int i = 0; i < segments.size(); ++i) {
            Segment segment = (Segment)segments.get(i);
            String toSet = null;
            toSet = segment.getId() == null || segment.getId().isEmpty() ? String.format(SEGMENTID_TEMPLATE, miningModel.getModelName(), i) : KiePMMLUtil.getSanitizedId(segment.getId(), miningModel.getModelName());
            segment.setId(toSet);
            Model model = segment.getModel();
            String modelName = String.format(SEGMENTMODELNAME_TEMPLATE, segment.getId(), model.getClass().getSimpleName());
            model.setModelName(modelName);
            if (!(segment.getModel() instanceof MiningModel)) continue;
            KiePMMLUtil.populateCorrectMiningModel((MiningModel)segment.getModel());
        }
    }

    static void populateMissingOutputFieldDataType(List<OutputField> toPopulate, List<MiningField> miningFields, List<DataField> dataFields) {
        List targetFields = miningFields.stream().filter(miningField -> MiningField.UsageType.PREDICTED.equals((Object)miningField.getUsageType()) || MiningField.UsageType.TARGET.equals((Object)miningField.getUsageType())).collect(Collectors.toList());
        toPopulate.stream().filter(outputField -> outputField.getDataType() == null).forEach(outputField -> {
            MiningField referencedField = null;
            if (outputField.getTargetField() != null) {
                referencedField = targetFields.stream().filter(targetField -> outputField.getTargetField().equals((Object)targetField.getName())).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find a target field for OutputField " + outputField.getName().getValue()));
            }
            if (referencedField == null && (outputField.getResultFeature() == null || outputField.getResultFeature().equals((Object)ResultFeature.PREDICTED_VALUE))) {
                referencedField = targetFields.stream().findFirst().orElse(null);
            }
            if (referencedField == null && ResultFeature.PROBABILITY.equals((Object)outputField.getResultFeature())) {
                outputField.setDataType(DataType.DOUBLE);
                return;
            }
            if (referencedField != null) {
                FieldName targetFieldName = referencedField.getName();
                DataField dataField = dataFields.stream().filter(df -> df.getName().equals((Object)targetFieldName)).findFirst().orElseThrow(() -> new KiePMMLException("Failed to find a DataField field for MiningField " + targetFieldName.toString()));
                outputField.setDataType(dataField.getDataType());
            }
        });
    }

    static String getSanitizedId(String id, String modelName) {
        String toReturn = id.replace(".", "").replace(",", "");
        try {
            Integer.parseInt(toReturn);
            toReturn = String.format(SEGMENTID_TEMPLATE, modelName, id);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return toReturn;
    }
}

