/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.utils;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.Target;
import org.dmg.pmml.Value;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.FIELD_USAGE_TYPE;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;
import org.kie.pmml.api.utils.PrimitiveBoxedUtils;
import org.kie.pmml.commons.model.tuples.KiePMMLNameOpType;

public class ModelUtils {
    private static final String INFINITY_SYMBOL = new String(Character.toString('\u221e').getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);

    private ModelUtils() {
    }

    public static Optional<String> getTargetFieldName(DataDictionary dataDictionary, Model model) {
        return ModelUtils.getTargetFields(dataDictionary, model).stream().map(KiePMMLNameOpType::getName).findFirst();
    }

    public static DATA_TYPE getTargetFieldType(DataDictionary dataDictionary, Model model) {
        return ModelUtils.getTargetFieldsTypeMap(dataDictionary, model).entrySet().iterator().next().getValue();
    }

    public static List<KiePMMLNameOpType> getTargetFields(DataDictionary dataDictionary, Model model) {
        ArrayList<KiePMMLNameOpType> toReturn = new ArrayList<KiePMMLNameOpType>();
        if (model.getTargets() != null && model.getTargets().getTargets() != null) {
            for (Target target : model.getTargets().getTargets()) {
                OP_TYPE opType = target.getOpType() != null ? OP_TYPE.byName((String)target.getOpType().value()) : ModelUtils.getOpType(dataDictionary, model, target.getField().getValue());
                toReturn.add(new KiePMMLNameOpType(target.getField().getValue(), opType));
            }
        } else {
            for (org.dmg.pmml.MiningField miningField : model.getMiningSchema().getMiningFields()) {
                if (!MiningField.UsageType.TARGET.equals((Object)miningField.getUsageType()) && !MiningField.UsageType.PREDICTED.equals((Object)miningField.getUsageType())) continue;
                OP_TYPE opType = miningField.getOpType() != null ? OP_TYPE.byName((String)miningField.getOpType().value()) : ModelUtils.getOpType(dataDictionary, model, miningField.getName().getValue());
                toReturn.add(new KiePMMLNameOpType(miningField.getName().getValue(), opType));
            }
        }
        return toReturn;
    }

    public static Map<String, DATA_TYPE> getTargetFieldsTypeMap(DataDictionary dataDictionary, Model model) {
        LinkedHashMap<String, DATA_TYPE> toReturn = new LinkedHashMap<String, DATA_TYPE>();
        if (model.getTargets() != null && model.getTargets().getTargets() != null) {
            for (Target target : model.getTargets().getTargets()) {
                toReturn.put(target.getField().getValue(), ModelUtils.getDataType(dataDictionary, target.getField().getValue()));
            }
        } else {
            for (org.dmg.pmml.MiningField miningField : model.getMiningSchema().getMiningFields()) {
                if (!MiningField.UsageType.TARGET.equals((Object)miningField.getUsageType()) && !MiningField.UsageType.PREDICTED.equals((Object)miningField.getUsageType())) continue;
                toReturn.put(miningField.getName().getValue(), ModelUtils.getDataType(dataDictionary, miningField.getName().getValue()));
            }
        }
        return toReturn;
    }

    public static OP_TYPE getOpType(DataDictionary dataDictionary, Model model, String targetFieldName) {
        Optional<OP_TYPE> toReturn = model.getMiningSchema().getMiningFields().stream().filter(dataField -> Objects.equals(targetFieldName, dataField.getName().getValue()) && dataField.getOpType() != null).findFirst().map(dataField -> OP_TYPE.byName((String)dataField.getOpType().value()));
        if (!toReturn.isPresent()) {
            toReturn = dataDictionary.getDataFields().stream().filter(dataField -> Objects.equals(targetFieldName, dataField.getName().getValue()) && dataField.getOpType() != null).findFirst().map(dataField -> OP_TYPE.byName((String)dataField.getOpType().value()));
        }
        return toReturn.orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find OpType for field %s", targetFieldName)));
    }

    public static DATA_TYPE getDataType(DataDictionary dataDictionary, String targetFieldName) {
        Optional<DATA_TYPE> toReturn = dataDictionary.getDataFields().stream().filter(dataField -> Objects.equals(targetFieldName, dataField.getName().getValue())).findFirst().map(dataField -> DATA_TYPE.byName((String)dataField.getDataType().value()));
        return toReturn.orElseThrow(() -> new KiePMMLInternalException(String.format("Failed to find DataType for field %s", targetFieldName)));
    }

    public static List<MiningField> convertToKieMiningFieldList(MiningSchema toConvert, DataDictionary dataDictionary) {
        if (toConvert == null) {
            return Collections.emptyList();
        }
        return toConvert.getMiningFields().stream().map(miningField -> {
            DataField dataField = dataDictionary.getDataFields().stream().filter(df -> df.getName().equals((Object)miningField.getName())).findFirst().orElseThrow(() -> new KiePMMLException("Cannot find " + miningField.getName() + " in DataDictionary"));
            return ModelUtils.convertToKieMiningField(miningField, dataField);
        }).collect(Collectors.toList());
    }

    public static MiningField convertToKieMiningField(org.dmg.pmml.MiningField toConvert, DataField dataField) {
        String name = toConvert.getName() != null ? toConvert.getName().getValue() : null;
        FIELD_USAGE_TYPE fieldUsageType = toConvert.getUsageType() != null ? FIELD_USAGE_TYPE.byName((String)toConvert.getUsageType().value()) : null;
        OP_TYPE opType = toConvert.getOpType() != null ? OP_TYPE.byName((String)toConvert.getOpType().value()) : null;
        DATA_TYPE dataType = dataField.getDataType() != null ? DATA_TYPE.byName((String)dataField.getDataType().value()) : null;
        String missingValueReplacement = toConvert.getMissingValueReplacement() != null ? toConvert.getMissingValueReplacement().toString() : null;
        List<String> allowedValues = ModelUtils.convertDataFieldValues(dataField.getValues());
        List<org.kie.pmml.api.models.Interval> intervals = ModelUtils.convertDataFieldIntervals(dataField.getIntervals());
        return new MiningField(name, fieldUsageType, opType, dataType, missingValueReplacement, allowedValues, intervals);
    }

    public static List<OutputField> convertToKieOutputFieldList(Output toConvert, DataDictionary dataDictionary) {
        if (toConvert == null) {
            return Collections.emptyList();
        }
        return toConvert.getOutputFields().stream().map(outputField -> {
            DataField dataField = dataDictionary.getDataFields().stream().filter(df -> df.getName().equals((Object)outputField.getTargetField())).findFirst().orElse(null);
            return ModelUtils.convertToKieOutputField(outputField, dataField);
        }).collect(Collectors.toList());
    }

    public static OutputField convertToKieOutputField(org.dmg.pmml.OutputField toConvert, DataField dataField) {
        String name = toConvert.getName() != null ? toConvert.getName().getValue() : null;
        OP_TYPE opType = toConvert.getOpType() != null ? OP_TYPE.byName((String)toConvert.getOpType().value()) : null;
        DATA_TYPE dataFieldDataType = dataField != null ? DATA_TYPE.byName((String)dataField.getDataType().value()) : null;
        DATA_TYPE dataType = toConvert.getDataType() != null ? DATA_TYPE.byName((String)toConvert.getDataType().value()) : dataFieldDataType;
        String targetField = toConvert.getTargetField() != null ? toConvert.getTargetField().getValue() : null;
        RESULT_FEATURE resultFeature = toConvert.getResultFeature() != null ? RESULT_FEATURE.byName((String)toConvert.getResultFeature().value()) : null;
        List<String> allowedValues = dataField != null ? ModelUtils.convertDataFieldValues(dataField.getValues()) : null;
        return new OutputField(name, opType, dataType, targetField, resultFeature, allowedValues);
    }

    public static String getBoxedClassName(ParameterField parameterField) {
        return parameterField.getDataType() == null ? Object.class.getName() : ModelUtils.getBoxedClassName(parameterField.getDataType());
    }

    public static String getBoxedClassName(DataType dataType) {
        Class c = dataType == null ? Object.class : DATA_TYPE.byName((String)dataType.value()).getMappedClass();
        return PrimitiveBoxedUtils.getKiePMMLPrimitiveBoxed((Class)c).map(primitiveBoxed -> primitiveBoxed.getBoxed().getName()).orElse(c.getName());
    }

    static List<String> convertDataFieldValues(List<Value> toConvert) {
        return toConvert != null ? toConvert.stream().map(value -> value.getValue().toString()).collect(Collectors.toList()) : null;
    }

    static List<org.kie.pmml.api.models.Interval> convertDataFieldIntervals(List<Interval> toConvert) {
        return toConvert != null ? toConvert.stream().map(interval -> new org.kie.pmml.api.models.Interval(interval.getLeftMargin(), interval.getRightMargin())).collect(Collectors.toList()) : null;
    }
}

