/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.api.model.spec;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="container-spec-details")
public class ContainerSpec
extends ContainerSpecKey {
    @XmlElement(name="release-id")
    private ReleaseId releasedId;
    @XmlElement(name="configuration")
    private Map<Capability, ContainerConfig> configs = new EnumMap<Capability, ContainerConfig>(Capability.class);
    @XmlElement(name="status")
    private KieContainerStatus status = KieContainerStatus.STOPPED;

    public ReleaseId getReleasedId() {
        return this.releasedId;
    }

    public ContainerSpec() {
    }

    public ContainerSpec(ContainerSpec other) {
        super(other.getId(), other.getContainerName(), other.getServerTemplateKey());
        this.releasedId = other.releasedId;
        this.status = other.status;
        this.configs = other.getConfigs().isEmpty() ? new EnumMap<Capability, ContainerConfig>(Capability.class) : new EnumMap<Capability, ContainerConfig>(other.getConfigs());
    }

    public ContainerSpec(String id, String containerName, ServerTemplateKey serverTemplateKey, ReleaseId releasedId, KieContainerStatus status, Map<Capability, ContainerConfig> configs) {
        super(id, containerName, serverTemplateKey);
        this.releasedId = releasedId;
        this.status = status;
        this.configs = configs;
    }

    public Map<Capability, ContainerConfig> getConfigs() {
        if (this.configs == null) {
            this.configs = new HashMap<Capability, ContainerConfig>();
        }
        return this.configs;
    }

    public KieContainerStatus getStatus() {
        return this.status;
    }

    public void setStatus(KieContainerStatus status) {
        this.status = status;
    }

    public void setReleasedId(ReleaseId releasedId) {
        this.releasedId = releasedId;
    }

    public void setConfigs(Map<Capability, ContainerConfig> configs) {
        this.configs = configs;
    }

    public void addConfig(Capability capability, ContainerConfig config) {
        this.configs.put(capability, config);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerSpec)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerSpec that = (ContainerSpec)o;
        return !(this.releasedId != null ? !this.releasedId.equals((Object)that.releasedId) : that.releasedId != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.releasedId != null ? this.releasedId.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ContainerSpec{releasedId=" + this.releasedId + ", configs=" + this.configs + ", status=" + this.status + "} " + super.toString();
    }
}

